package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.CertificateValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CertificateList(
    signingAlg: zio.aws.iotwireless.model.SigningAlg,
    value: CertificateValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CertificateList = {
    import CertificateList.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CertificateList
      .builder()
      .signingAlg(signingAlg.unwrap)
      .value(CertificateValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.CertificateList.ReadOnly =
    zio.aws.iotwireless.model.CertificateList.wrap(buildAwsValue())
}
object CertificateList {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CertificateList
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.CertificateList =
      zio.aws.iotwireless.model.CertificateList(signingAlg, value)
    def signingAlg: zio.aws.iotwireless.model.SigningAlg
    def value: CertificateValue
    def getSigningAlg: ZIO[Any, Nothing, zio.aws.iotwireless.model.SigningAlg] =
      ZIO.succeed(signingAlg)
    def getValue: ZIO[Any, Nothing, CertificateValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CertificateList
  ) extends zio.aws.iotwireless.model.CertificateList.ReadOnly {
    override val signingAlg: zio.aws.iotwireless.model.SigningAlg =
      zio.aws.iotwireless.model.SigningAlg.wrap(impl.signingAlg())
    override val value: CertificateValue =
      zio.aws.iotwireless.model.primitives.CertificateValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CertificateList
  ): zio.aws.iotwireless.model.CertificateList.ReadOnly = new Wrapper(impl)
}
