package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.MulticastGroupId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CancelMulticastGroupSessionRequest(id: MulticastGroupId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CancelMulticastGroupSessionRequest = {
    import CancelMulticastGroupSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CancelMulticastGroupSessionRequest
      .builder()
      .id(MulticastGroupId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.CancelMulticastGroupSessionRequest.ReadOnly =
    zio.aws.iotwireless.model.CancelMulticastGroupSessionRequest
      .wrap(buildAwsValue())
}
object CancelMulticastGroupSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CancelMulticastGroupSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.CancelMulticastGroupSessionRequest =
      zio.aws.iotwireless.model.CancelMulticastGroupSessionRequest(id)
    def id: MulticastGroupId
    def getId: ZIO[Any, Nothing, MulticastGroupId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CancelMulticastGroupSessionRequest
  ) extends zio.aws.iotwireless.model.CancelMulticastGroupSessionRequest.ReadOnly {
    override val id: MulticastGroupId =
      zio.aws.iotwireless.model.primitives.MulticastGroupId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CancelMulticastGroupSessionRequest
  ): zio.aws.iotwireless.model.CancelMulticastGroupSessionRequest.ReadOnly =
    new Wrapper(impl)
}
