package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  VerticalAccuracy,
  HorizontalAccuracy
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Accuracy(
    horizontalAccuracy: Optional[HorizontalAccuracy] = Optional.Absent,
    verticalAccuracy: Optional[VerticalAccuracy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.Accuracy = {
    import Accuracy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.Accuracy
      .builder()
      .optionallyWith(
        horizontalAccuracy.map(value =>
          HorizontalAccuracy.unwrap(value): java.lang.Float
        )
      )(_.horizontalAccuracy)
      .optionallyWith(
        verticalAccuracy.map(value =>
          VerticalAccuracy.unwrap(value): java.lang.Float
        )
      )(_.verticalAccuracy)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.Accuracy.ReadOnly =
    zio.aws.iotwireless.model.Accuracy.wrap(buildAwsValue())
}
object Accuracy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.Accuracy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.Accuracy =
      zio.aws.iotwireless.model.Accuracy(
        horizontalAccuracy.map(value => value),
        verticalAccuracy.map(value => value)
      )
    def horizontalAccuracy: Optional[HorizontalAccuracy]
    def verticalAccuracy: Optional[VerticalAccuracy]
    def getHorizontalAccuracy: ZIO[Any, AwsError, HorizontalAccuracy] =
      AwsError.unwrapOptionField("horizontalAccuracy", horizontalAccuracy)
    def getVerticalAccuracy: ZIO[Any, AwsError, VerticalAccuracy] =
      AwsError.unwrapOptionField("verticalAccuracy", verticalAccuracy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.Accuracy
  ) extends zio.aws.iotwireless.model.Accuracy.ReadOnly {
    override val horizontalAccuracy: Optional[HorizontalAccuracy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.horizontalAccuracy())
        .map(value =>
          zio.aws.iotwireless.model.primitives.HorizontalAccuracy(value)
        )
    override val verticalAccuracy: Optional[VerticalAccuracy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verticalAccuracy())
        .map(value =>
          zio.aws.iotwireless.model.primitives.VerticalAccuracy(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.Accuracy
  ): zio.aws.iotwireless.model.Accuracy.ReadOnly = new Wrapper(impl)
}
