package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait WirelessGatewayType {
  def unwrap
      : software.amazon.awssdk.services.iotwireless.model.WirelessGatewayType
}
object WirelessGatewayType {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.WirelessGatewayType
  ): zio.aws.iotwireless.model.WirelessGatewayType = value match {
    case software.amazon.awssdk.services.iotwireless.model.WirelessGatewayType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessGatewayType.LO_RA_WAN =>
      val r = LoRaWAN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.WirelessGatewayType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessGatewayType =
      software.amazon.awssdk.services.iotwireless.model.WirelessGatewayType.UNKNOWN_TO_SDK_VERSION
  }
  case object LoRaWAN extends zio.aws.iotwireless.model.WirelessGatewayType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessGatewayType =
      software.amazon.awssdk.services.iotwireless.model.WirelessGatewayType.LO_RA_WAN
  }
}
