package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  WirelessGatewayId,
  WirelessGatewayArn,
  ISODateTimeString,
  WirelessGatewayName,
  Description
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class WirelessGatewayStatistics(
    arn: Optional[WirelessGatewayArn] = Optional.Absent,
    id: Optional[WirelessGatewayId] = Optional.Absent,
    name: Optional[WirelessGatewayName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    loRaWAN: Optional[zio.aws.iotwireless.model.LoRaWANGateway] =
      Optional.Absent,
    lastUplinkReceivedAt: Optional[ISODateTimeString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.WirelessGatewayStatistics = {
    import WirelessGatewayStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.WirelessGatewayStatistics
      .builder()
      .optionallyWith(
        arn.map(value => WirelessGatewayArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        id.map(value => WirelessGatewayId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => WirelessGatewayName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .optionallyWith(
        lastUplinkReceivedAt.map(value =>
          ISODateTimeString.unwrap(value): java.lang.String
        )
      )(_.lastUplinkReceivedAt)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.WirelessGatewayStatistics.ReadOnly =
    zio.aws.iotwireless.model.WirelessGatewayStatistics.wrap(buildAwsValue())
}
object WirelessGatewayStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.WirelessGatewayStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.WirelessGatewayStatistics =
      zio.aws.iotwireless.model.WirelessGatewayStatistics(
        arn.map(value => value),
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        loRaWAN.map(value => value.asEditable),
        lastUplinkReceivedAt.map(value => value)
      )
    def arn: Optional[WirelessGatewayArn]
    def id: Optional[WirelessGatewayId]
    def name: Optional[WirelessGatewayName]
    def description: Optional[Description]
    def loRaWAN: Optional[zio.aws.iotwireless.model.LoRaWANGateway.ReadOnly]
    def lastUplinkReceivedAt: Optional[ISODateTimeString]
    def getArn: ZIO[Any, AwsError, WirelessGatewayArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, WirelessGatewayId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, WirelessGatewayName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANGateway.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
    def getLastUplinkReceivedAt: ZIO[Any, AwsError, ISODateTimeString] =
      AwsError.unwrapOptionField("lastUplinkReceivedAt", lastUplinkReceivedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.WirelessGatewayStatistics
  ) extends zio.aws.iotwireless.model.WirelessGatewayStatistics.ReadOnly {
    override val arn: Optional[WirelessGatewayArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessGatewayArn(value)
      )
    override val id: Optional[WirelessGatewayId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessGatewayId(value)
      )
    override val name: Optional[WirelessGatewayName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessGatewayName(value)
      )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val loRaWAN
        : Optional[zio.aws.iotwireless.model.LoRaWANGateway.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loRaWAN())
        .map(value => zio.aws.iotwireless.model.LoRaWANGateway.wrap(value))
    override val lastUplinkReceivedAt: Optional[ISODateTimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUplinkReceivedAt())
        .map(value =>
          zio.aws.iotwireless.model.primitives.ISODateTimeString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.WirelessGatewayStatistics
  ): zio.aws.iotwireless.model.WirelessGatewayStatistics.ReadOnly = new Wrapper(
    impl
  )
}
