package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.PartnerAccountId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdatePartnerAccountRequest(
    sidewalk: zio.aws.iotwireless.model.SidewalkUpdateAccount,
    partnerAccountId: PartnerAccountId,
    partnerType: zio.aws.iotwireless.model.PartnerType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.UpdatePartnerAccountRequest = {
    import UpdatePartnerAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.UpdatePartnerAccountRequest
      .builder()
      .sidewalk(sidewalk.buildAwsValue())
      .partnerAccountId(
        PartnerAccountId.unwrap(partnerAccountId): java.lang.String
      )
      .partnerType(partnerType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.UpdatePartnerAccountRequest.ReadOnly =
    zio.aws.iotwireless.model.UpdatePartnerAccountRequest.wrap(buildAwsValue())
}
object UpdatePartnerAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.UpdatePartnerAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.UpdatePartnerAccountRequest =
      zio.aws.iotwireless.model.UpdatePartnerAccountRequest(
        sidewalk.asEditable,
        partnerAccountId,
        partnerType
      )
    def sidewalk: zio.aws.iotwireless.model.SidewalkUpdateAccount.ReadOnly
    def partnerAccountId: PartnerAccountId
    def partnerType: zio.aws.iotwireless.model.PartnerType
    def getSidewalk: ZIO[
      Any,
      Nothing,
      zio.aws.iotwireless.model.SidewalkUpdateAccount.ReadOnly
    ] = ZIO.succeed(sidewalk)
    def getPartnerAccountId: ZIO[Any, Nothing, PartnerAccountId] =
      ZIO.succeed(partnerAccountId)
    def getPartnerType
        : ZIO[Any, Nothing, zio.aws.iotwireless.model.PartnerType] =
      ZIO.succeed(partnerType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdatePartnerAccountRequest
  ) extends zio.aws.iotwireless.model.UpdatePartnerAccountRequest.ReadOnly {
    override val sidewalk
        : zio.aws.iotwireless.model.SidewalkUpdateAccount.ReadOnly =
      zio.aws.iotwireless.model.SidewalkUpdateAccount.wrap(impl.sidewalk())
    override val partnerAccountId: PartnerAccountId =
      zio.aws.iotwireless.model.primitives
        .PartnerAccountId(impl.partnerAccountId())
    override val partnerType: zio.aws.iotwireless.model.PartnerType =
      zio.aws.iotwireless.model.PartnerType.wrap(impl.partnerType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdatePartnerAccountRequest
  ): zio.aws.iotwireless.model.UpdatePartnerAccountRequest.ReadOnly =
    new Wrapper(impl)
}
