package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  Description,
  MulticastGroupName,
  MulticastGroupId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateMulticastGroupRequest(
    id: MulticastGroupId,
    name: Optional[MulticastGroupName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    loRaWAN: Optional[zio.aws.iotwireless.model.LoRaWANMulticast] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.UpdateMulticastGroupRequest = {
    import UpdateMulticastGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.UpdateMulticastGroupRequest
      .builder()
      .id(MulticastGroupId.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value => MulticastGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.UpdateMulticastGroupRequest.ReadOnly =
    zio.aws.iotwireless.model.UpdateMulticastGroupRequest.wrap(buildAwsValue())
}
object UpdateMulticastGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.UpdateMulticastGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.UpdateMulticastGroupRequest =
      zio.aws.iotwireless.model.UpdateMulticastGroupRequest(
        id,
        name.map(value => value),
        description.map(value => value),
        loRaWAN.map(value => value.asEditable)
      )
    def id: MulticastGroupId
    def name: Optional[MulticastGroupName]
    def description: Optional[Description]
    def loRaWAN: Optional[zio.aws.iotwireless.model.LoRaWANMulticast.ReadOnly]
    def getId: ZIO[Any, Nothing, MulticastGroupId] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, MulticastGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANMulticast.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateMulticastGroupRequest
  ) extends zio.aws.iotwireless.model.UpdateMulticastGroupRequest.ReadOnly {
    override val id: MulticastGroupId =
      zio.aws.iotwireless.model.primitives.MulticastGroupId(impl.id())
    override val name: Optional[MulticastGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.MulticastGroupName(value)
      )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val loRaWAN
        : Optional[zio.aws.iotwireless.model.LoRaWANMulticast.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loRaWAN())
        .map(value => zio.aws.iotwireless.model.LoRaWANMulticast.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateMulticastGroupRequest
  ): zio.aws.iotwireless.model.UpdateMulticastGroupRequest.ReadOnly =
    new Wrapper(impl)
}
