package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateEventConfigurationByResourceTypesRequest(
    deviceRegistrationState: Optional[
      zio.aws.iotwireless.model.DeviceRegistrationStateResourceTypeEventConfiguration
    ] = Optional.Absent,
    proximity: Optional[
      zio.aws.iotwireless.model.ProximityResourceTypeEventConfiguration
    ] = Optional.Absent,
    join: Optional[
      zio.aws.iotwireless.model.JoinResourceTypeEventConfiguration
    ] = Optional.Absent,
    connectionStatus: Optional[
      zio.aws.iotwireless.model.ConnectionStatusResourceTypeEventConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.UpdateEventConfigurationByResourceTypesRequest = {
    import UpdateEventConfigurationByResourceTypesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.UpdateEventConfigurationByResourceTypesRequest
      .builder()
      .optionallyWith(
        deviceRegistrationState.map(value => value.buildAwsValue())
      )(_.deviceRegistrationState)
      .optionallyWith(proximity.map(value => value.buildAwsValue()))(
        _.proximity
      )
      .optionallyWith(join.map(value => value.buildAwsValue()))(_.join)
      .optionallyWith(connectionStatus.map(value => value.buildAwsValue()))(
        _.connectionStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.UpdateEventConfigurationByResourceTypesRequest.ReadOnly =
    zio.aws.iotwireless.model.UpdateEventConfigurationByResourceTypesRequest
      .wrap(buildAwsValue())
}
object UpdateEventConfigurationByResourceTypesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.UpdateEventConfigurationByResourceTypesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.UpdateEventConfigurationByResourceTypesRequest =
      zio.aws.iotwireless.model.UpdateEventConfigurationByResourceTypesRequest(
        deviceRegistrationState.map(value => value.asEditable),
        proximity.map(value => value.asEditable),
        join.map(value => value.asEditable),
        connectionStatus.map(value => value.asEditable)
      )
    def deviceRegistrationState: Optional[
      zio.aws.iotwireless.model.DeviceRegistrationStateResourceTypeEventConfiguration.ReadOnly
    ]
    def proximity: Optional[
      zio.aws.iotwireless.model.ProximityResourceTypeEventConfiguration.ReadOnly
    ]
    def join: Optional[
      zio.aws.iotwireless.model.JoinResourceTypeEventConfiguration.ReadOnly
    ]
    def connectionStatus: Optional[
      zio.aws.iotwireless.model.ConnectionStatusResourceTypeEventConfiguration.ReadOnly
    ]
    def getDeviceRegistrationState: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.DeviceRegistrationStateResourceTypeEventConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deviceRegistrationState",
      deviceRegistrationState
    )
    def getProximity: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.ProximityResourceTypeEventConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("proximity", proximity)
    def getJoin: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.JoinResourceTypeEventConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("join", join)
    def getConnectionStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.ConnectionStatusResourceTypeEventConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("connectionStatus", connectionStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateEventConfigurationByResourceTypesRequest
  ) extends zio.aws.iotwireless.model.UpdateEventConfigurationByResourceTypesRequest.ReadOnly {
    override val deviceRegistrationState: Optional[
      zio.aws.iotwireless.model.DeviceRegistrationStateResourceTypeEventConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceRegistrationState())
      .map(value =>
        zio.aws.iotwireless.model.DeviceRegistrationStateResourceTypeEventConfiguration
          .wrap(value)
      )
    override val proximity: Optional[
      zio.aws.iotwireless.model.ProximityResourceTypeEventConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.proximity())
      .map(value =>
        zio.aws.iotwireless.model.ProximityResourceTypeEventConfiguration
          .wrap(value)
      )
    override val join: Optional[
      zio.aws.iotwireless.model.JoinResourceTypeEventConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.join())
      .map(value =>
        zio.aws.iotwireless.model.JoinResourceTypeEventConfiguration.wrap(value)
      )
    override val connectionStatus: Optional[
      zio.aws.iotwireless.model.ConnectionStatusResourceTypeEventConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionStatus())
      .map(value =>
        zio.aws.iotwireless.model.ConnectionStatusResourceTypeEventConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateEventConfigurationByResourceTypesRequest
  ): zio.aws.iotwireless.model.UpdateEventConfigurationByResourceTypesRequest.ReadOnly =
    new Wrapper(impl)
}
