package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.FCntStart
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateAbpV1_0_x(
    fCntStart: Optional[FCntStart] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.UpdateAbpV1_0_x = {
    import UpdateAbpV1_0_x.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.UpdateAbpV1_0_x
      .builder()
      .optionallyWith(fCntStart.map(value => FCntStart.unwrap(value): Integer))(
        _.fCntStart
      )
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.UpdateAbpV1_0_x.ReadOnly =
    zio.aws.iotwireless.model.UpdateAbpV1_0_x.wrap(buildAwsValue())
}
object UpdateAbpV1_0_x {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.UpdateAbpV1_0_x
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.UpdateAbpV1_0_x =
      zio.aws.iotwireless.model.UpdateAbpV1_0_x(fCntStart.map(value => value))
    def fCntStart: Optional[FCntStart]
    def getFCntStart: ZIO[Any, AwsError, FCntStart] =
      AwsError.unwrapOptionField("fCntStart", fCntStart)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateAbpV1_0_x
  ) extends zio.aws.iotwireless.model.UpdateAbpV1_0_x.ReadOnly {
    override val fCntStart: Optional[FCntStart] = zio.aws.core.internal
      .optionalFromNullable(impl.fCntStart())
      .map(value => zio.aws.iotwireless.model.primitives.FCntStart(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateAbpV1_0_x
  ): zio.aws.iotwireless.model.UpdateAbpV1_0_x.ReadOnly = new Wrapper(impl)
}
