package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TraceContent(
    wirelessDeviceFrameInfo: Optional[
      zio.aws.iotwireless.model.WirelessDeviceFrameInfo
    ] = Optional.Absent,
    logLevel: Optional[zio.aws.iotwireless.model.LogLevel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.TraceContent = {
    import TraceContent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.TraceContent
      .builder()
      .optionallyWith(wirelessDeviceFrameInfo.map(value => value.unwrap))(
        _.wirelessDeviceFrameInfo
      )
      .optionallyWith(logLevel.map(value => value.unwrap))(_.logLevel)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.TraceContent.ReadOnly =
    zio.aws.iotwireless.model.TraceContent.wrap(buildAwsValue())
}
object TraceContent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.TraceContent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.TraceContent =
      zio.aws.iotwireless.model.TraceContent(
        wirelessDeviceFrameInfo.map(value => value),
        logLevel.map(value => value)
      )
    def wirelessDeviceFrameInfo
        : Optional[zio.aws.iotwireless.model.WirelessDeviceFrameInfo]
    def logLevel: Optional[zio.aws.iotwireless.model.LogLevel]
    def getWirelessDeviceFrameInfo: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.WirelessDeviceFrameInfo
    ] = AwsError.unwrapOptionField(
      "wirelessDeviceFrameInfo",
      wirelessDeviceFrameInfo
    )
    def getLogLevel: ZIO[Any, AwsError, zio.aws.iotwireless.model.LogLevel] =
      AwsError.unwrapOptionField("logLevel", logLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.TraceContent
  ) extends zio.aws.iotwireless.model.TraceContent.ReadOnly {
    override val wirelessDeviceFrameInfo
        : Optional[zio.aws.iotwireless.model.WirelessDeviceFrameInfo] =
      zio.aws.core.internal
        .optionalFromNullable(impl.wirelessDeviceFrameInfo())
        .map(value =>
          zio.aws.iotwireless.model.WirelessDeviceFrameInfo.wrap(value)
        )
    override val logLevel: Optional[zio.aws.iotwireless.model.LogLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logLevel())
        .map(value => zio.aws.iotwireless.model.LogLevel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.TraceContent
  ): zio.aws.iotwireless.model.TraceContent.ReadOnly = new Wrapper(impl)
}
