package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.AppServerPrivateKey
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SidewalkUpdateAccount(
    appServerPrivateKey: Optional[AppServerPrivateKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.SidewalkUpdateAccount = {
    import SidewalkUpdateAccount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.SidewalkUpdateAccount
      .builder()
      .optionallyWith(
        appServerPrivateKey.map(value =>
          AppServerPrivateKey.unwrap(value): java.lang.String
        )
      )(_.appServerPrivateKey)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.SidewalkUpdateAccount.ReadOnly =
    zio.aws.iotwireless.model.SidewalkUpdateAccount.wrap(buildAwsValue())
}
object SidewalkUpdateAccount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.SidewalkUpdateAccount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.SidewalkUpdateAccount =
      zio.aws.iotwireless.model
        .SidewalkUpdateAccount(appServerPrivateKey.map(value => value))
    def appServerPrivateKey: Optional[AppServerPrivateKey]
    def getAppServerPrivateKey: ZIO[Any, AwsError, AppServerPrivateKey] =
      AwsError.unwrapOptionField("appServerPrivateKey", appServerPrivateKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkUpdateAccount
  ) extends zio.aws.iotwireless.model.SidewalkUpdateAccount.ReadOnly {
    override val appServerPrivateKey: Optional[AppServerPrivateKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appServerPrivateKey())
        .map(value =>
          zio.aws.iotwireless.model.primitives.AppServerPrivateKey(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkUpdateAccount
  ): zio.aws.iotwireless.model.SidewalkUpdateAccount.ReadOnly = new Wrapper(
    impl
  )
}
