package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  SidewalkManufacturingSn,
  SidewalkId,
  AmazonId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SidewalkListDevice(
    amazonId: Optional[AmazonId] = Optional.Absent,
    sidewalkId: Optional[SidewalkId] = Optional.Absent,
    sidewalkManufacturingSn: Optional[SidewalkManufacturingSn] =
      Optional.Absent,
    deviceCertificates: Optional[
      Iterable[zio.aws.iotwireless.model.CertificateList]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.SidewalkListDevice = {
    import SidewalkListDevice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.SidewalkListDevice
      .builder()
      .optionallyWith(
        amazonId.map(value => AmazonId.unwrap(value): java.lang.String)
      )(_.amazonId)
      .optionallyWith(
        sidewalkId.map(value => SidewalkId.unwrap(value): java.lang.String)
      )(_.sidewalkId)
      .optionallyWith(
        sidewalkManufacturingSn.map(value =>
          SidewalkManufacturingSn.unwrap(value): java.lang.String
        )
      )(_.sidewalkManufacturingSn)
      .optionallyWith(
        deviceCertificates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deviceCertificates)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.SidewalkListDevice.ReadOnly =
    zio.aws.iotwireless.model.SidewalkListDevice.wrap(buildAwsValue())
}
object SidewalkListDevice {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.SidewalkListDevice
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.SidewalkListDevice =
      zio.aws.iotwireless.model.SidewalkListDevice(
        amazonId.map(value => value),
        sidewalkId.map(value => value),
        sidewalkManufacturingSn.map(value => value),
        deviceCertificates.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def amazonId: Optional[AmazonId]
    def sidewalkId: Optional[SidewalkId]
    def sidewalkManufacturingSn: Optional[SidewalkManufacturingSn]
    def deviceCertificates
        : Optional[List[zio.aws.iotwireless.model.CertificateList.ReadOnly]]
    def getAmazonId: ZIO[Any, AwsError, AmazonId] =
      AwsError.unwrapOptionField("amazonId", amazonId)
    def getSidewalkId: ZIO[Any, AwsError, SidewalkId] =
      AwsError.unwrapOptionField("sidewalkId", sidewalkId)
    def getSidewalkManufacturingSn
        : ZIO[Any, AwsError, SidewalkManufacturingSn] = AwsError
      .unwrapOptionField("sidewalkManufacturingSn", sidewalkManufacturingSn)
    def getDeviceCertificates: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.CertificateList.ReadOnly
    ]] = AwsError.unwrapOptionField("deviceCertificates", deviceCertificates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkListDevice
  ) extends zio.aws.iotwireless.model.SidewalkListDevice.ReadOnly {
    override val amazonId: Optional[AmazonId] = zio.aws.core.internal
      .optionalFromNullable(impl.amazonId())
      .map(value => zio.aws.iotwireless.model.primitives.AmazonId(value))
    override val sidewalkId: Optional[SidewalkId] = zio.aws.core.internal
      .optionalFromNullable(impl.sidewalkId())
      .map(value => zio.aws.iotwireless.model.primitives.SidewalkId(value))
    override val sidewalkManufacturingSn: Optional[SidewalkManufacturingSn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sidewalkManufacturingSn())
        .map(value =>
          zio.aws.iotwireless.model.primitives.SidewalkManufacturingSn(value)
        )
    override val deviceCertificates
        : Optional[List[zio.aws.iotwireless.model.CertificateList.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceCertificates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.CertificateList.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkListDevice
  ): zio.aws.iotwireless.model.SidewalkListDevice.ReadOnly = new Wrapper(impl)
}
