package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait LogLevel {
  def unwrap: software.amazon.awssdk.services.iotwireless.model.LogLevel
}
object LogLevel {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.LogLevel
  ): zio.aws.iotwireless.model.LogLevel = value match {
    case software.amazon.awssdk.services.iotwireless.model.LogLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.LogLevel.INFO =>
      val r = INFO
      r
    case software.amazon.awssdk.services.iotwireless.model.LogLevel.ERROR =>
      val r = ERROR
      r
    case software.amazon.awssdk.services.iotwireless.model.LogLevel.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.iotwireless.model.LogLevel {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.LogLevel =
      software.amazon.awssdk.services.iotwireless.model.LogLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object INFO extends zio.aws.iotwireless.model.LogLevel {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.LogLevel =
      software.amazon.awssdk.services.iotwireless.model.LogLevel.INFO
  }
  case object ERROR extends zio.aws.iotwireless.model.LogLevel {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.LogLevel =
      software.amazon.awssdk.services.iotwireless.model.LogLevel.ERROR
  }
  case object DISABLED extends zio.aws.iotwireless.model.LogLevel {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.LogLevel =
      software.amazon.awssdk.services.iotwireless.model.LogLevel.DISABLED
  }
}
