package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.AddGwMetadata
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LoRaWANServiceProfile(
    addGwMetadata: Optional[AddGwMetadata] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANServiceProfile = {
    import LoRaWANServiceProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANServiceProfile
      .builder()
      .optionallyWith(
        addGwMetadata.map(value =>
          AddGwMetadata.unwrap(value): java.lang.Boolean
        )
      )(_.addGwMetadata)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.LoRaWANServiceProfile.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANServiceProfile.wrap(buildAwsValue())
}
object LoRaWANServiceProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANServiceProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANServiceProfile =
      zio.aws.iotwireless.model
        .LoRaWANServiceProfile(addGwMetadata.map(value => value))
    def addGwMetadata: Optional[AddGwMetadata]
    def getAddGwMetadata: ZIO[Any, AwsError, AddGwMetadata] =
      AwsError.unwrapOptionField("addGwMetadata", addGwMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANServiceProfile
  ) extends zio.aws.iotwireless.model.LoRaWANServiceProfile.ReadOnly {
    override val addGwMetadata: Optional[AddGwMetadata] = zio.aws.core.internal
      .optionalFromNullable(impl.addGwMetadata())
      .map(value => zio.aws.iotwireless.model.primitives.AddGwMetadata(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANServiceProfile
  ): zio.aws.iotwireless.model.LoRaWANServiceProfile.ReadOnly = new Wrapper(
    impl
  )
}
