package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.FPort
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class LoRaWANMulticastMetadata(
    fPort: Optional[FPort] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticastMetadata = {
    import LoRaWANMulticastMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticastMetadata
      .builder()
      .optionallyWith(fPort.map(value => FPort.unwrap(value): Integer))(_.fPort)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.LoRaWANMulticastMetadata.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANMulticastMetadata.wrap(buildAwsValue())
}
object LoRaWANMulticastMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticastMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANMulticastMetadata =
      zio.aws.iotwireless.model
        .LoRaWANMulticastMetadata(fPort.map(value => value))
    def fPort: Optional[FPort]
    def getFPort: ZIO[Any, AwsError, FPort] =
      AwsError.unwrapOptionField("fPort", fPort)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticastMetadata
  ) extends zio.aws.iotwireless.model.LoRaWANMulticastMetadata.ReadOnly {
    override val fPort: Optional[FPort] = zio.aws.core.internal
      .optionalFromNullable(impl.fPort())
      .map(value => zio.aws.iotwireless.model.primitives.FPort(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticastMetadata
  ): zio.aws.iotwireless.model.LoRaWANMulticastMetadata.ReadOnly = new Wrapper(
    impl
  )
}
