package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{
  DlRatePolicy,
  ReportDevStatusBattery,
  ReportDevStatusMargin,
  UlRate,
  DrMin,
  UlBucketSize,
  DevStatusReqFreq,
  HrAllowed,
  AddGwMetadata,
  DrMax,
  RaAllowed,
  UlRatePolicy,
  PrAllowed,
  NwkGeoLoc,
  TargetPer,
  DlBucketSize,
  DlRate,
  ChannelMask,
  MinGwDiversity
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class LoRaWANGetServiceProfileInfo(
    ulRate: Optional[UlRate] = Optional.Absent,
    ulBucketSize: Optional[UlBucketSize] = Optional.Absent,
    ulRatePolicy: Optional[UlRatePolicy] = Optional.Absent,
    dlRate: Optional[DlRate] = Optional.Absent,
    dlBucketSize: Optional[DlBucketSize] = Optional.Absent,
    dlRatePolicy: Optional[DlRatePolicy] = Optional.Absent,
    addGwMetadata: Optional[AddGwMetadata] = Optional.Absent,
    devStatusReqFreq: Optional[DevStatusReqFreq] = Optional.Absent,
    reportDevStatusBattery: Optional[ReportDevStatusBattery] = Optional.Absent,
    reportDevStatusMargin: Optional[ReportDevStatusMargin] = Optional.Absent,
    drMin: Optional[DrMin] = Optional.Absent,
    drMax: Optional[DrMax] = Optional.Absent,
    channelMask: Optional[ChannelMask] = Optional.Absent,
    prAllowed: Optional[PrAllowed] = Optional.Absent,
    hrAllowed: Optional[HrAllowed] = Optional.Absent,
    raAllowed: Optional[RaAllowed] = Optional.Absent,
    nwkGeoLoc: Optional[NwkGeoLoc] = Optional.Absent,
    targetPer: Optional[TargetPer] = Optional.Absent,
    minGwDiversity: Optional[MinGwDiversity] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANGetServiceProfileInfo = {
    import LoRaWANGetServiceProfileInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANGetServiceProfileInfo
      .builder()
      .optionallyWith(ulRate.map(value => UlRate.unwrap(value): Integer))(
        _.ulRate
      )
      .optionallyWith(
        ulBucketSize.map(value => UlBucketSize.unwrap(value): Integer)
      )(_.ulBucketSize)
      .optionallyWith(
        ulRatePolicy.map(value => UlRatePolicy.unwrap(value): java.lang.String)
      )(_.ulRatePolicy)
      .optionallyWith(dlRate.map(value => DlRate.unwrap(value): Integer))(
        _.dlRate
      )
      .optionallyWith(
        dlBucketSize.map(value => DlBucketSize.unwrap(value): Integer)
      )(_.dlBucketSize)
      .optionallyWith(
        dlRatePolicy.map(value => DlRatePolicy.unwrap(value): java.lang.String)
      )(_.dlRatePolicy)
      .optionallyWith(
        addGwMetadata.map(value =>
          AddGwMetadata.unwrap(value): java.lang.Boolean
        )
      )(_.addGwMetadata)
      .optionallyWith(
        devStatusReqFreq.map(value => DevStatusReqFreq.unwrap(value): Integer)
      )(_.devStatusReqFreq)
      .optionallyWith(
        reportDevStatusBattery.map(value =>
          ReportDevStatusBattery.unwrap(value): java.lang.Boolean
        )
      )(_.reportDevStatusBattery)
      .optionallyWith(
        reportDevStatusMargin.map(value =>
          ReportDevStatusMargin.unwrap(value): java.lang.Boolean
        )
      )(_.reportDevStatusMargin)
      .optionallyWith(drMin.map(value => DrMin.unwrap(value): Integer))(_.drMin)
      .optionallyWith(drMax.map(value => DrMax.unwrap(value): Integer))(_.drMax)
      .optionallyWith(
        channelMask.map(value => ChannelMask.unwrap(value): java.lang.String)
      )(_.channelMask)
      .optionallyWith(
        prAllowed.map(value => PrAllowed.unwrap(value): java.lang.Boolean)
      )(_.prAllowed)
      .optionallyWith(
        hrAllowed.map(value => HrAllowed.unwrap(value): java.lang.Boolean)
      )(_.hrAllowed)
      .optionallyWith(
        raAllowed.map(value => RaAllowed.unwrap(value): java.lang.Boolean)
      )(_.raAllowed)
      .optionallyWith(
        nwkGeoLoc.map(value => NwkGeoLoc.unwrap(value): java.lang.Boolean)
      )(_.nwkGeoLoc)
      .optionallyWith(targetPer.map(value => TargetPer.unwrap(value): Integer))(
        _.targetPer
      )
      .optionallyWith(
        minGwDiversity.map(value => MinGwDiversity.unwrap(value): Integer)
      )(_.minGwDiversity)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.LoRaWANGetServiceProfileInfo.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANGetServiceProfileInfo.wrap(buildAwsValue())
}
object LoRaWANGetServiceProfileInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANGetServiceProfileInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANGetServiceProfileInfo =
      zio.aws.iotwireless.model.LoRaWANGetServiceProfileInfo(
        ulRate.map(value => value),
        ulBucketSize.map(value => value),
        ulRatePolicy.map(value => value),
        dlRate.map(value => value),
        dlBucketSize.map(value => value),
        dlRatePolicy.map(value => value),
        addGwMetadata.map(value => value),
        devStatusReqFreq.map(value => value),
        reportDevStatusBattery.map(value => value),
        reportDevStatusMargin.map(value => value),
        drMin.map(value => value),
        drMax.map(value => value),
        channelMask.map(value => value),
        prAllowed.map(value => value),
        hrAllowed.map(value => value),
        raAllowed.map(value => value),
        nwkGeoLoc.map(value => value),
        targetPer.map(value => value),
        minGwDiversity.map(value => value)
      )
    def ulRate: Optional[UlRate]
    def ulBucketSize: Optional[UlBucketSize]
    def ulRatePolicy: Optional[UlRatePolicy]
    def dlRate: Optional[DlRate]
    def dlBucketSize: Optional[DlBucketSize]
    def dlRatePolicy: Optional[DlRatePolicy]
    def addGwMetadata: Optional[AddGwMetadata]
    def devStatusReqFreq: Optional[DevStatusReqFreq]
    def reportDevStatusBattery: Optional[ReportDevStatusBattery]
    def reportDevStatusMargin: Optional[ReportDevStatusMargin]
    def drMin: Optional[DrMin]
    def drMax: Optional[DrMax]
    def channelMask: Optional[ChannelMask]
    def prAllowed: Optional[PrAllowed]
    def hrAllowed: Optional[HrAllowed]
    def raAllowed: Optional[RaAllowed]
    def nwkGeoLoc: Optional[NwkGeoLoc]
    def targetPer: Optional[TargetPer]
    def minGwDiversity: Optional[MinGwDiversity]
    def getUlRate: ZIO[Any, AwsError, UlRate] =
      AwsError.unwrapOptionField("ulRate", ulRate)
    def getUlBucketSize: ZIO[Any, AwsError, UlBucketSize] =
      AwsError.unwrapOptionField("ulBucketSize", ulBucketSize)
    def getUlRatePolicy: ZIO[Any, AwsError, UlRatePolicy] =
      AwsError.unwrapOptionField("ulRatePolicy", ulRatePolicy)
    def getDlRate: ZIO[Any, AwsError, DlRate] =
      AwsError.unwrapOptionField("dlRate", dlRate)
    def getDlBucketSize: ZIO[Any, AwsError, DlBucketSize] =
      AwsError.unwrapOptionField("dlBucketSize", dlBucketSize)
    def getDlRatePolicy: ZIO[Any, AwsError, DlRatePolicy] =
      AwsError.unwrapOptionField("dlRatePolicy", dlRatePolicy)
    def getAddGwMetadata: ZIO[Any, AwsError, AddGwMetadata] =
      AwsError.unwrapOptionField("addGwMetadata", addGwMetadata)
    def getDevStatusReqFreq: ZIO[Any, AwsError, DevStatusReqFreq] =
      AwsError.unwrapOptionField("devStatusReqFreq", devStatusReqFreq)
    def getReportDevStatusBattery: ZIO[Any, AwsError, ReportDevStatusBattery] =
      AwsError.unwrapOptionField(
        "reportDevStatusBattery",
        reportDevStatusBattery
      )
    def getReportDevStatusMargin: ZIO[Any, AwsError, ReportDevStatusMargin] =
      AwsError.unwrapOptionField("reportDevStatusMargin", reportDevStatusMargin)
    def getDrMin: ZIO[Any, AwsError, DrMin] =
      AwsError.unwrapOptionField("drMin", drMin)
    def getDrMax: ZIO[Any, AwsError, DrMax] =
      AwsError.unwrapOptionField("drMax", drMax)
    def getChannelMask: ZIO[Any, AwsError, ChannelMask] =
      AwsError.unwrapOptionField("channelMask", channelMask)
    def getPrAllowed: ZIO[Any, AwsError, PrAllowed] =
      AwsError.unwrapOptionField("prAllowed", prAllowed)
    def getHrAllowed: ZIO[Any, AwsError, HrAllowed] =
      AwsError.unwrapOptionField("hrAllowed", hrAllowed)
    def getRaAllowed: ZIO[Any, AwsError, RaAllowed] =
      AwsError.unwrapOptionField("raAllowed", raAllowed)
    def getNwkGeoLoc: ZIO[Any, AwsError, NwkGeoLoc] =
      AwsError.unwrapOptionField("nwkGeoLoc", nwkGeoLoc)
    def getTargetPer: ZIO[Any, AwsError, TargetPer] =
      AwsError.unwrapOptionField("targetPer", targetPer)
    def getMinGwDiversity: ZIO[Any, AwsError, MinGwDiversity] =
      AwsError.unwrapOptionField("minGwDiversity", minGwDiversity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANGetServiceProfileInfo
  ) extends zio.aws.iotwireless.model.LoRaWANGetServiceProfileInfo.ReadOnly {
    override val ulRate: Optional[UlRate] = zio.aws.core.internal
      .optionalFromNullable(impl.ulRate())
      .map(value => zio.aws.iotwireless.model.primitives.UlRate(value))
    override val ulBucketSize: Optional[UlBucketSize] = zio.aws.core.internal
      .optionalFromNullable(impl.ulBucketSize())
      .map(value => zio.aws.iotwireless.model.primitives.UlBucketSize(value))
    override val ulRatePolicy: Optional[UlRatePolicy] = zio.aws.core.internal
      .optionalFromNullable(impl.ulRatePolicy())
      .map(value => zio.aws.iotwireless.model.primitives.UlRatePolicy(value))
    override val dlRate: Optional[DlRate] = zio.aws.core.internal
      .optionalFromNullable(impl.dlRate())
      .map(value => zio.aws.iotwireless.model.primitives.DlRate(value))
    override val dlBucketSize: Optional[DlBucketSize] = zio.aws.core.internal
      .optionalFromNullable(impl.dlBucketSize())
      .map(value => zio.aws.iotwireless.model.primitives.DlBucketSize(value))
    override val dlRatePolicy: Optional[DlRatePolicy] = zio.aws.core.internal
      .optionalFromNullable(impl.dlRatePolicy())
      .map(value => zio.aws.iotwireless.model.primitives.DlRatePolicy(value))
    override val addGwMetadata: Optional[AddGwMetadata] = zio.aws.core.internal
      .optionalFromNullable(impl.addGwMetadata())
      .map(value => zio.aws.iotwireless.model.primitives.AddGwMetadata(value))
    override val devStatusReqFreq: Optional[DevStatusReqFreq] =
      zio.aws.core.internal
        .optionalFromNullable(impl.devStatusReqFreq())
        .map(value =>
          zio.aws.iotwireless.model.primitives.DevStatusReqFreq(value)
        )
    override val reportDevStatusBattery: Optional[ReportDevStatusBattery] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reportDevStatusBattery())
        .map(value =>
          zio.aws.iotwireless.model.primitives.ReportDevStatusBattery(value)
        )
    override val reportDevStatusMargin: Optional[ReportDevStatusMargin] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reportDevStatusMargin())
        .map(value =>
          zio.aws.iotwireless.model.primitives.ReportDevStatusMargin(value)
        )
    override val drMin: Optional[DrMin] = zio.aws.core.internal
      .optionalFromNullable(impl.drMin())
      .map(value => zio.aws.iotwireless.model.primitives.DrMin(value))
    override val drMax: Optional[DrMax] = zio.aws.core.internal
      .optionalFromNullable(impl.drMax())
      .map(value => zio.aws.iotwireless.model.primitives.DrMax(value))
    override val channelMask: Optional[ChannelMask] = zio.aws.core.internal
      .optionalFromNullable(impl.channelMask())
      .map(value => zio.aws.iotwireless.model.primitives.ChannelMask(value))
    override val prAllowed: Optional[PrAllowed] = zio.aws.core.internal
      .optionalFromNullable(impl.prAllowed())
      .map(value => zio.aws.iotwireless.model.primitives.PrAllowed(value))
    override val hrAllowed: Optional[HrAllowed] = zio.aws.core.internal
      .optionalFromNullable(impl.hrAllowed())
      .map(value => zio.aws.iotwireless.model.primitives.HrAllowed(value))
    override val raAllowed: Optional[RaAllowed] = zio.aws.core.internal
      .optionalFromNullable(impl.raAllowed())
      .map(value => zio.aws.iotwireless.model.primitives.RaAllowed(value))
    override val nwkGeoLoc: Optional[NwkGeoLoc] = zio.aws.core.internal
      .optionalFromNullable(impl.nwkGeoLoc())
      .map(value => zio.aws.iotwireless.model.primitives.NwkGeoLoc(value))
    override val targetPer: Optional[TargetPer] = zio.aws.core.internal
      .optionalFromNullable(impl.targetPer())
      .map(value => zio.aws.iotwireless.model.primitives.TargetPer(value))
    override val minGwDiversity: Optional[MinGwDiversity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minGwDiversity())
        .map(value =>
          zio.aws.iotwireless.model.primitives.MinGwDiversity(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANGetServiceProfileInfo
  ): zio.aws.iotwireless.model.LoRaWANGetServiceProfileInfo.ReadOnly =
    new Wrapper(impl)
}
