package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LoRaWANGatewayCurrentVersion(
    currentVersion: Optional[zio.aws.iotwireless.model.LoRaWANGatewayVersion] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANGatewayCurrentVersion = {
    import LoRaWANGatewayCurrentVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANGatewayCurrentVersion
      .builder()
      .optionallyWith(currentVersion.map(value => value.buildAwsValue()))(
        _.currentVersion
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.LoRaWANGatewayCurrentVersion.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANGatewayCurrentVersion.wrap(buildAwsValue())
}
object LoRaWANGatewayCurrentVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANGatewayCurrentVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANGatewayCurrentVersion =
      zio.aws.iotwireless.model.LoRaWANGatewayCurrentVersion(
        currentVersion.map(value => value.asEditable)
      )
    def currentVersion
        : Optional[zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly]
    def getCurrentVersion: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly
    ] = AwsError.unwrapOptionField("currentVersion", currentVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANGatewayCurrentVersion
  ) extends zio.aws.iotwireless.model.LoRaWANGatewayCurrentVersion.ReadOnly {
    override val currentVersion
        : Optional[zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentVersion())
        .map(value =>
          zio.aws.iotwireless.model.LoRaWANGatewayVersion.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANGatewayCurrentVersion
  ): zio.aws.iotwireless.model.LoRaWANGatewayCurrentVersion.ReadOnly =
    new Wrapper(impl)
}
