package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LoRaWANFuotaTask(
    rfRegion: Optional[zio.aws.iotwireless.model.SupportedRfRegion] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANFuotaTask = {
    import LoRaWANFuotaTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANFuotaTask
      .builder()
      .optionallyWith(rfRegion.map(value => value.unwrap))(_.rfRegion)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.LoRaWANFuotaTask.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANFuotaTask.wrap(buildAwsValue())
}
object LoRaWANFuotaTask {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANFuotaTask
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANFuotaTask =
      zio.aws.iotwireless.model.LoRaWANFuotaTask(rfRegion.map(value => value))
    def rfRegion: Optional[zio.aws.iotwireless.model.SupportedRfRegion]
    def getRfRegion
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.SupportedRfRegion] =
      AwsError.unwrapOptionField("rfRegion", rfRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANFuotaTask
  ) extends zio.aws.iotwireless.model.LoRaWANFuotaTask.ReadOnly {
    override val rfRegion
        : Optional[zio.aws.iotwireless.model.SupportedRfRegion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rfRegion())
        .map(value => zio.aws.iotwireless.model.SupportedRfRegion.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANFuotaTask
  ): zio.aws.iotwireless.model.LoRaWANFuotaTask.ReadOnly = new Wrapper(impl)
}
