package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  ServiceProfileId,
  DeviceProfileId,
  DevEui
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LoRaWANDevice(
    devEui: Optional[DevEui] = Optional.Absent,
    deviceProfileId: Optional[DeviceProfileId] = Optional.Absent,
    serviceProfileId: Optional[ServiceProfileId] = Optional.Absent,
    otaaV1_1: Optional[zio.aws.iotwireless.model.OtaaV1_1] = Optional.Absent,
    otaaV1_0_x: Optional[zio.aws.iotwireless.model.OtaaV1_0_x] =
      Optional.Absent,
    abpV1_1: Optional[zio.aws.iotwireless.model.AbpV1_1] = Optional.Absent,
    abpV1_0_x: Optional[zio.aws.iotwireless.model.AbpV1_0_x] = Optional.Absent,
    fPorts: Optional[zio.aws.iotwireless.model.FPorts] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANDevice = {
    import LoRaWANDevice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANDevice
      .builder()
      .optionallyWith(
        devEui.map(value => DevEui.unwrap(value): java.lang.String)
      )(_.devEui)
      .optionallyWith(
        deviceProfileId.map(value =>
          DeviceProfileId.unwrap(value): java.lang.String
        )
      )(_.deviceProfileId)
      .optionallyWith(
        serviceProfileId.map(value =>
          ServiceProfileId.unwrap(value): java.lang.String
        )
      )(_.serviceProfileId)
      .optionallyWith(otaaV1_1.map(value => value.buildAwsValue()))(_.otaaV1_1)
      .optionallyWith(otaaV1_0_x.map(value => value.buildAwsValue()))(
        _.otaaV1_0_x
      )
      .optionallyWith(abpV1_1.map(value => value.buildAwsValue()))(_.abpV1_1)
      .optionallyWith(abpV1_0_x.map(value => value.buildAwsValue()))(
        _.abpV1_0_x
      )
      .optionallyWith(fPorts.map(value => value.buildAwsValue()))(_.fPorts)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.LoRaWANDevice.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANDevice.wrap(buildAwsValue())
}
object LoRaWANDevice {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANDevice
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANDevice =
      zio.aws.iotwireless.model.LoRaWANDevice(
        devEui.map(value => value),
        deviceProfileId.map(value => value),
        serviceProfileId.map(value => value),
        otaaV1_1.map(value => value.asEditable),
        otaaV1_0_x.map(value => value.asEditable),
        abpV1_1.map(value => value.asEditable),
        abpV1_0_x.map(value => value.asEditable),
        fPorts.map(value => value.asEditable)
      )
    def devEui: Optional[DevEui]
    def deviceProfileId: Optional[DeviceProfileId]
    def serviceProfileId: Optional[ServiceProfileId]
    def otaaV1_1: Optional[zio.aws.iotwireless.model.OtaaV1_1.ReadOnly]
    def otaaV1_0_x: Optional[zio.aws.iotwireless.model.OtaaV1_0_x.ReadOnly]
    def abpV1_1: Optional[zio.aws.iotwireless.model.AbpV1_1.ReadOnly]
    def abpV1_0_x: Optional[zio.aws.iotwireless.model.AbpV1_0_x.ReadOnly]
    def fPorts: Optional[zio.aws.iotwireless.model.FPorts.ReadOnly]
    def getDevEui: ZIO[Any, AwsError, DevEui] =
      AwsError.unwrapOptionField("devEui", devEui)
    def getDeviceProfileId: ZIO[Any, AwsError, DeviceProfileId] =
      AwsError.unwrapOptionField("deviceProfileId", deviceProfileId)
    def getServiceProfileId: ZIO[Any, AwsError, ServiceProfileId] =
      AwsError.unwrapOptionField("serviceProfileId", serviceProfileId)
    def getOtaaV1_1
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.OtaaV1_1.ReadOnly] =
      AwsError.unwrapOptionField("otaaV1_1", otaaV1_1)
    def getOtaaV1_0_x
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.OtaaV1_0_x.ReadOnly] =
      AwsError.unwrapOptionField("otaaV1_0_x", otaaV1_0_x)
    def getAbpV1_1
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.AbpV1_1.ReadOnly] =
      AwsError.unwrapOptionField("abpV1_1", abpV1_1)
    def getAbpV1_0_x
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.AbpV1_0_x.ReadOnly] =
      AwsError.unwrapOptionField("abpV1_0_x", abpV1_0_x)
    def getFPorts
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.FPorts.ReadOnly] =
      AwsError.unwrapOptionField("fPorts", fPorts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANDevice
  ) extends zio.aws.iotwireless.model.LoRaWANDevice.ReadOnly {
    override val devEui: Optional[DevEui] = zio.aws.core.internal
      .optionalFromNullable(impl.devEui())
      .map(value => zio.aws.iotwireless.model.primitives.DevEui(value))
    override val deviceProfileId: Optional[DeviceProfileId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceProfileId())
        .map(value =>
          zio.aws.iotwireless.model.primitives.DeviceProfileId(value)
        )
    override val serviceProfileId: Optional[ServiceProfileId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceProfileId())
        .map(value =>
          zio.aws.iotwireless.model.primitives.ServiceProfileId(value)
        )
    override val otaaV1_1
        : Optional[zio.aws.iotwireless.model.OtaaV1_1.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.otaaV1_1())
        .map(value => zio.aws.iotwireless.model.OtaaV1_1.wrap(value))
    override val otaaV1_0_x
        : Optional[zio.aws.iotwireless.model.OtaaV1_0_x.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.otaaV1_0_x())
        .map(value => zio.aws.iotwireless.model.OtaaV1_0_x.wrap(value))
    override val abpV1_1: Optional[zio.aws.iotwireless.model.AbpV1_1.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.abpV1_1())
        .map(value => zio.aws.iotwireless.model.AbpV1_1.wrap(value))
    override val abpV1_0_x
        : Optional[zio.aws.iotwireless.model.AbpV1_0_x.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.abpV1_0_x())
        .map(value => zio.aws.iotwireless.model.AbpV1_0_x.wrap(value))
    override val fPorts: Optional[zio.aws.iotwireless.model.FPorts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fPorts())
        .map(value => zio.aws.iotwireless.model.FPorts.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANDevice
  ): zio.aws.iotwireless.model.LoRaWANDevice.ReadOnly = new Wrapper(impl)
}
