package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LoRaWANConnectionStatusEventNotificationConfigurations(
    gatewayEuiEventTopic: Optional[
      zio.aws.iotwireless.model.EventNotificationTopicStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANConnectionStatusEventNotificationConfigurations = {
    import LoRaWANConnectionStatusEventNotificationConfigurations.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANConnectionStatusEventNotificationConfigurations
      .builder()
      .optionallyWith(gatewayEuiEventTopic.map(value => value.unwrap))(
        _.gatewayEuiEventTopic
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.LoRaWANConnectionStatusEventNotificationConfigurations.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANConnectionStatusEventNotificationConfigurations
      .wrap(buildAwsValue())
}
object LoRaWANConnectionStatusEventNotificationConfigurations {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANConnectionStatusEventNotificationConfigurations
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.LoRaWANConnectionStatusEventNotificationConfigurations =
      zio.aws.iotwireless.model
        .LoRaWANConnectionStatusEventNotificationConfigurations(
          gatewayEuiEventTopic.map(value => value)
        )
    def gatewayEuiEventTopic
        : Optional[zio.aws.iotwireless.model.EventNotificationTopicStatus]
    def getGatewayEuiEventTopic: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.EventNotificationTopicStatus
    ] = AwsError.unwrapOptionField("gatewayEuiEventTopic", gatewayEuiEventTopic)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANConnectionStatusEventNotificationConfigurations
  ) extends zio.aws.iotwireless.model.LoRaWANConnectionStatusEventNotificationConfigurations.ReadOnly {
    override val gatewayEuiEventTopic
        : Optional[zio.aws.iotwireless.model.EventNotificationTopicStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gatewayEuiEventTopic())
        .map(value =>
          zio.aws.iotwireless.model.EventNotificationTopicStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANConnectionStatusEventNotificationConfigurations
  ): zio.aws.iotwireless.model.LoRaWANConnectionStatusEventNotificationConfigurations.ReadOnly =
    new Wrapper(impl)
}
