package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListWirelessGatewaysResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    wirelessGatewayList: Optional[
      Iterable[zio.aws.iotwireless.model.WirelessGatewayStatistics]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse = {
    import ListWirelessGatewaysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        wirelessGatewayList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.wirelessGatewayList)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ListWirelessGatewaysResponse.ReadOnly =
    zio.aws.iotwireless.model.ListWirelessGatewaysResponse.wrap(buildAwsValue())
}
object ListWirelessGatewaysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.ListWirelessGatewaysResponse =
      zio.aws.iotwireless.model.ListWirelessGatewaysResponse(
        nextToken.map(value => value),
        wirelessGatewayList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def wirelessGatewayList: Optional[
      List[zio.aws.iotwireless.model.WirelessGatewayStatistics.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getWirelessGatewayList: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.WirelessGatewayStatistics.ReadOnly
    ]] = AwsError.unwrapOptionField("wirelessGatewayList", wirelessGatewayList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse
  ) extends zio.aws.iotwireless.model.ListWirelessGatewaysResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
    override val wirelessGatewayList: Optional[
      List[zio.aws.iotwireless.model.WirelessGatewayStatistics.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.wirelessGatewayList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.WirelessGatewayStatistics.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse
  ): zio.aws.iotwireless.model.ListWirelessGatewaysResponse.ReadOnly =
    new Wrapper(impl)
}
