package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListWirelessGatewayTaskDefinitionsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    taskDefinitions: Optional[
      Iterable[zio.aws.iotwireless.model.UpdateWirelessGatewayTaskEntry]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse = {
    import ListWirelessGatewayTaskDefinitionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        taskDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.taskDefinitions)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse.ReadOnly =
    zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse
      .wrap(buildAwsValue())
}
object ListWirelessGatewayTaskDefinitionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse =
      zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse(
        nextToken.map(value => value),
        taskDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def taskDefinitions: Optional[
      List[zio.aws.iotwireless.model.UpdateWirelessGatewayTaskEntry.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTaskDefinitions: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.UpdateWirelessGatewayTaskEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("taskDefinitions", taskDefinitions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse
  ) extends zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
    override val taskDefinitions: Optional[
      List[zio.aws.iotwireless.model.UpdateWirelessGatewayTaskEntry.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.taskDefinitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.UpdateWirelessGatewayTaskEntry.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse
  ): zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse.ReadOnly =
    new Wrapper(impl)
}
