package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListServiceProfilesResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    serviceProfileList: Optional[
      Iterable[zio.aws.iotwireless.model.ServiceProfile]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesResponse = {
    import ListServiceProfilesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        serviceProfileList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceProfileList)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ListServiceProfilesResponse.ReadOnly =
    zio.aws.iotwireless.model.ListServiceProfilesResponse.wrap(buildAwsValue())
}
object ListServiceProfilesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.ListServiceProfilesResponse =
      zio.aws.iotwireless.model.ListServiceProfilesResponse(
        nextToken.map(value => value),
        serviceProfileList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def serviceProfileList
        : Optional[List[zio.aws.iotwireless.model.ServiceProfile.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getServiceProfileList: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.ServiceProfile.ReadOnly
    ]] = AwsError.unwrapOptionField("serviceProfileList", serviceProfileList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesResponse
  ) extends zio.aws.iotwireless.model.ListServiceProfilesResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
    override val serviceProfileList
        : Optional[List[zio.aws.iotwireless.model.ServiceProfile.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceProfileList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.ServiceProfile.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesResponse
  ): zio.aws.iotwireless.model.ListServiceProfilesResponse.ReadOnly =
    new Wrapper(impl)
}
