package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{NextToken, MaxResults}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListNetworkAnalyzerConfigurationsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsRequest = {
    import ListNetworkAnalyzerConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ListNetworkAnalyzerConfigurationsRequest.ReadOnly =
    zio.aws.iotwireless.model.ListNetworkAnalyzerConfigurationsRequest
      .wrap(buildAwsValue())
}
object ListNetworkAnalyzerConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.ListNetworkAnalyzerConfigurationsRequest =
      zio.aws.iotwireless.model.ListNetworkAnalyzerConfigurationsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsRequest
  ) extends zio.aws.iotwireless.model.ListNetworkAnalyzerConfigurationsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotwireless.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsRequest
  ): zio.aws.iotwireless.model.ListNetworkAnalyzerConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
