package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListMulticastGroupsByFuotaTaskResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    multicastGroupList: Optional[
      Iterable[zio.aws.iotwireless.model.MulticastGroupByFuotaTask]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse = {
    import ListMulticastGroupsByFuotaTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        multicastGroupList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.multicastGroupList)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse.ReadOnly =
    zio.aws.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse
      .wrap(buildAwsValue())
}
object ListMulticastGroupsByFuotaTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse =
      zio.aws.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse(
        nextToken.map(value => value),
        multicastGroupList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def multicastGroupList: Optional[
      List[zio.aws.iotwireless.model.MulticastGroupByFuotaTask.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMulticastGroupList: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.MulticastGroupByFuotaTask.ReadOnly
    ]] = AwsError.unwrapOptionField("multicastGroupList", multicastGroupList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse
  ) extends zio.aws.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
    override val multicastGroupList: Optional[
      List[zio.aws.iotwireless.model.MulticastGroupByFuotaTask.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.multicastGroupList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.MulticastGroupByFuotaTask.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse
  ): zio.aws.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse.ReadOnly =
    new Wrapper(impl)
}
