package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class JoinResourceTypeEventConfiguration(
    loRaWAN: Optional[
      zio.aws.iotwireless.model.LoRaWANJoinResourceTypeEventConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.JoinResourceTypeEventConfiguration = {
    import JoinResourceTypeEventConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.JoinResourceTypeEventConfiguration
      .builder()
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.JoinResourceTypeEventConfiguration.ReadOnly =
    zio.aws.iotwireless.model.JoinResourceTypeEventConfiguration
      .wrap(buildAwsValue())
}
object JoinResourceTypeEventConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.JoinResourceTypeEventConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.JoinResourceTypeEventConfiguration =
      zio.aws.iotwireless.model.JoinResourceTypeEventConfiguration(
        loRaWAN.map(value => value.asEditable)
      )
    def loRaWAN: Optional[
      zio.aws.iotwireless.model.LoRaWANJoinResourceTypeEventConfiguration.ReadOnly
    ]
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANJoinResourceTypeEventConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.JoinResourceTypeEventConfiguration
  ) extends zio.aws.iotwireless.model.JoinResourceTypeEventConfiguration.ReadOnly {
    override val loRaWAN: Optional[
      zio.aws.iotwireless.model.LoRaWANJoinResourceTypeEventConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.loRaWAN())
      .map(value =>
        zio.aws.iotwireless.model.LoRaWANJoinResourceTypeEventConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.JoinResourceTypeEventConfiguration
  ): zio.aws.iotwireless.model.JoinResourceTypeEventConfiguration.ReadOnly =
    new Wrapper(impl)
}
