package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  WirelessGatewayTaskDefinitionArn,
  WirelessGatewayTaskName,
  AutoCreateTasks
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetWirelessGatewayTaskDefinitionResponse(
    autoCreateTasks: Optional[AutoCreateTasks] = Optional.Absent,
    name: Optional[WirelessGatewayTaskName] = Optional.Absent,
    update: Optional[
      zio.aws.iotwireless.model.UpdateWirelessGatewayTaskCreate
    ] = Optional.Absent,
    arn: Optional[WirelessGatewayTaskDefinitionArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse = {
    import GetWirelessGatewayTaskDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse
      .builder()
      .optionallyWith(
        autoCreateTasks.map(value =>
          AutoCreateTasks.unwrap(value): java.lang.Boolean
        )
      )(_.autoCreateTasks)
      .optionallyWith(
        name.map(value =>
          WirelessGatewayTaskName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(update.map(value => value.buildAwsValue()))(_.update)
      .optionallyWith(
        arn.map(value =>
          WirelessGatewayTaskDefinitionArn.unwrap(value): java.lang.String
        )
      )(_.arn)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse.ReadOnly =
    zio.aws.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse
      .wrap(buildAwsValue())
}
object GetWirelessGatewayTaskDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse =
      zio.aws.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse(
        autoCreateTasks.map(value => value),
        name.map(value => value),
        update.map(value => value.asEditable),
        arn.map(value => value)
      )
    def autoCreateTasks: Optional[AutoCreateTasks]
    def name: Optional[WirelessGatewayTaskName]
    def update: Optional[
      zio.aws.iotwireless.model.UpdateWirelessGatewayTaskCreate.ReadOnly
    ]
    def arn: Optional[WirelessGatewayTaskDefinitionArn]
    def getAutoCreateTasks: ZIO[Any, AwsError, AutoCreateTasks] =
      AwsError.unwrapOptionField("autoCreateTasks", autoCreateTasks)
    def getName: ZIO[Any, AwsError, WirelessGatewayTaskName] =
      AwsError.unwrapOptionField("name", name)
    def getUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.UpdateWirelessGatewayTaskCreate.ReadOnly
    ] = AwsError.unwrapOptionField("update", update)
    def getArn: ZIO[Any, AwsError, WirelessGatewayTaskDefinitionArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse
  ) extends zio.aws.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse.ReadOnly {
    override val autoCreateTasks: Optional[AutoCreateTasks] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoCreateTasks())
        .map(value =>
          zio.aws.iotwireless.model.primitives.AutoCreateTasks(value)
        )
    override val name: Optional[WirelessGatewayTaskName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessGatewayTaskName(value)
      )
    override val update: Optional[
      zio.aws.iotwireless.model.UpdateWirelessGatewayTaskCreate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.update())
      .map(value =>
        zio.aws.iotwireless.model.UpdateWirelessGatewayTaskCreate.wrap(value)
      )
    override val arn: Optional[WirelessGatewayTaskDefinitionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.arn())
        .map(value =>
          zio.aws.iotwireless.model.primitives
            .WirelessGatewayTaskDefinitionArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse
  ): zio.aws.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
