package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetLogLevelsByResourceTypesResponse(
    defaultLogLevel: Optional[zio.aws.iotwireless.model.LogLevel] =
      Optional.Absent,
    wirelessGatewayLogOptions: Optional[
      Iterable[zio.aws.iotwireless.model.WirelessGatewayLogOption]
    ] = Optional.Absent,
    wirelessDeviceLogOptions: Optional[
      Iterable[zio.aws.iotwireless.model.WirelessDeviceLogOption]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetLogLevelsByResourceTypesResponse = {
    import GetLogLevelsByResourceTypesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetLogLevelsByResourceTypesResponse
      .builder()
      .optionallyWith(defaultLogLevel.map(value => value.unwrap))(
        _.defaultLogLevel
      )
      .optionallyWith(
        wirelessGatewayLogOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.wirelessGatewayLogOptions)
      .optionallyWith(
        wirelessDeviceLogOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.wirelessDeviceLogOptions)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetLogLevelsByResourceTypesResponse.ReadOnly =
    zio.aws.iotwireless.model.GetLogLevelsByResourceTypesResponse
      .wrap(buildAwsValue())
}
object GetLogLevelsByResourceTypesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetLogLevelsByResourceTypesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.GetLogLevelsByResourceTypesResponse =
      zio.aws.iotwireless.model.GetLogLevelsByResourceTypesResponse(
        defaultLogLevel.map(value => value),
        wirelessGatewayLogOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        wirelessDeviceLogOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def defaultLogLevel: Optional[zio.aws.iotwireless.model.LogLevel]
    def wirelessGatewayLogOptions: Optional[
      List[zio.aws.iotwireless.model.WirelessGatewayLogOption.ReadOnly]
    ]
    def wirelessDeviceLogOptions: Optional[
      List[zio.aws.iotwireless.model.WirelessDeviceLogOption.ReadOnly]
    ]
    def getDefaultLogLevel
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.LogLevel] =
      AwsError.unwrapOptionField("defaultLogLevel", defaultLogLevel)
    def getWirelessGatewayLogOptions: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.WirelessGatewayLogOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "wirelessGatewayLogOptions",
      wirelessGatewayLogOptions
    )
    def getWirelessDeviceLogOptions: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.WirelessDeviceLogOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "wirelessDeviceLogOptions",
      wirelessDeviceLogOptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetLogLevelsByResourceTypesResponse
  ) extends zio.aws.iotwireless.model.GetLogLevelsByResourceTypesResponse.ReadOnly {
    override val defaultLogLevel: Optional[zio.aws.iotwireless.model.LogLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultLogLevel())
        .map(value => zio.aws.iotwireless.model.LogLevel.wrap(value))
    override val wirelessGatewayLogOptions: Optional[
      List[zio.aws.iotwireless.model.WirelessGatewayLogOption.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.wirelessGatewayLogOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.WirelessGatewayLogOption.wrap(item)
        }.toList
      )
    override val wirelessDeviceLogOptions: Optional[
      List[zio.aws.iotwireless.model.WirelessDeviceLogOption.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.wirelessDeviceLogOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.WirelessDeviceLogOption.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetLogLevelsByResourceTypesResponse
  ): zio.aws.iotwireless.model.GetLogLevelsByResourceTypesResponse.ReadOnly =
    new Wrapper(impl)
}
