package zio.aws.iotwireless.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{
  FirmwareUpdateRole,
  CreatedAt,
  FirmwareUpdateImage,
  FuotaTaskName,
  Description,
  FuotaTaskArn,
  FuotaTaskId
}
import scala.jdk.CollectionConverters._
final case class GetFuotaTaskResponse(
    arn: Optional[FuotaTaskArn] = Optional.Absent,
    id: Optional[FuotaTaskId] = Optional.Absent,
    status: Optional[zio.aws.iotwireless.model.FuotaTaskStatus] =
      Optional.Absent,
    name: Optional[FuotaTaskName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    loRaWAN: Optional[zio.aws.iotwireless.model.LoRaWANFuotaTaskGetInfo] =
      Optional.Absent,
    firmwareUpdateImage: Optional[FirmwareUpdateImage] = Optional.Absent,
    firmwareUpdateRole: Optional[FirmwareUpdateRole] = Optional.Absent,
    createdAt: Optional[CreatedAt] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetFuotaTaskResponse = {
    import GetFuotaTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetFuotaTaskResponse
      .builder()
      .optionallyWith(
        arn.map(value => FuotaTaskArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        id.map(value => FuotaTaskId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        name.map(value => FuotaTaskName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .optionallyWith(
        firmwareUpdateImage.map(value =>
          FirmwareUpdateImage.unwrap(value): java.lang.String
        )
      )(_.firmwareUpdateImage)
      .optionallyWith(
        firmwareUpdateRole.map(value =>
          FirmwareUpdateRole.unwrap(value): java.lang.String
        )
      )(_.firmwareUpdateRole)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.GetFuotaTaskResponse.ReadOnly =
    zio.aws.iotwireless.model.GetFuotaTaskResponse.wrap(buildAwsValue())
}
object GetFuotaTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetFuotaTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetFuotaTaskResponse =
      zio.aws.iotwireless.model.GetFuotaTaskResponse(
        arn.map(value => value),
        id.map(value => value),
        status.map(value => value),
        name.map(value => value),
        description.map(value => value),
        loRaWAN.map(value => value.asEditable),
        firmwareUpdateImage.map(value => value),
        firmwareUpdateRole.map(value => value),
        createdAt.map(value => value)
      )
    def arn: Optional[FuotaTaskArn]
    def id: Optional[FuotaTaskId]
    def status: Optional[zio.aws.iotwireless.model.FuotaTaskStatus]
    def name: Optional[FuotaTaskName]
    def description: Optional[Description]
    def loRaWAN
        : Optional[zio.aws.iotwireless.model.LoRaWANFuotaTaskGetInfo.ReadOnly]
    def firmwareUpdateImage: Optional[FirmwareUpdateImage]
    def firmwareUpdateRole: Optional[FirmwareUpdateRole]
    def createdAt: Optional[CreatedAt]
    def getArn: ZIO[Any, AwsError, FuotaTaskArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, FuotaTaskId] =
      AwsError.unwrapOptionField("id", id)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.FuotaTaskStatus] =
      AwsError.unwrapOptionField("status", status)
    def getName: ZIO[Any, AwsError, FuotaTaskName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANFuotaTaskGetInfo.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
    def getFirmwareUpdateImage: ZIO[Any, AwsError, FirmwareUpdateImage] =
      AwsError.unwrapOptionField("firmwareUpdateImage", firmwareUpdateImage)
    def getFirmwareUpdateRole: ZIO[Any, AwsError, FirmwareUpdateRole] =
      AwsError.unwrapOptionField("firmwareUpdateRole", firmwareUpdateRole)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetFuotaTaskResponse
  ) extends zio.aws.iotwireless.model.GetFuotaTaskResponse.ReadOnly {
    override val arn: Optional[FuotaTaskArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.iotwireless.model.primitives.FuotaTaskArn(value))
    override val id: Optional[FuotaTaskId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.iotwireless.model.primitives.FuotaTaskId(value))
    override val status: Optional[zio.aws.iotwireless.model.FuotaTaskStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iotwireless.model.FuotaTaskStatus.wrap(value))
    override val name: Optional[FuotaTaskName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.iotwireless.model.primitives.FuotaTaskName(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val loRaWAN
        : Optional[zio.aws.iotwireless.model.LoRaWANFuotaTaskGetInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loRaWAN())
        .map(value =>
          zio.aws.iotwireless.model.LoRaWANFuotaTaskGetInfo.wrap(value)
        )
    override val firmwareUpdateImage: Optional[FirmwareUpdateImage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firmwareUpdateImage())
        .map(value =>
          zio.aws.iotwireless.model.primitives.FirmwareUpdateImage(value)
        )
    override val firmwareUpdateRole: Optional[FirmwareUpdateRole] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firmwareUpdateRole())
        .map(value =>
          zio.aws.iotwireless.model.primitives.FirmwareUpdateRole(value)
        )
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.iotwireless.model.primitives.CreatedAt(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetFuotaTaskResponse
  ): zio.aws.iotwireless.model.GetFuotaTaskResponse.ReadOnly = new Wrapper(impl)
}
