package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait EventNotificationTopicStatus {
  def unwrap: software.amazon.awssdk.services.iotwireless.model.EventNotificationTopicStatus
}
object EventNotificationTopicStatus {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.EventNotificationTopicStatus
  ): zio.aws.iotwireless.model.EventNotificationTopicStatus = value match {
    case software.amazon.awssdk.services.iotwireless.model.EventNotificationTopicStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.EventNotificationTopicStatus.ENABLED =>
      val r = Enabled
      r
    case software.amazon.awssdk.services.iotwireless.model.EventNotificationTopicStatus.DISABLED =>
      val r = Disabled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.EventNotificationTopicStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.EventNotificationTopicStatus =
      software.amazon.awssdk.services.iotwireless.model.EventNotificationTopicStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled
      extends zio.aws.iotwireless.model.EventNotificationTopicStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.EventNotificationTopicStatus =
      software.amazon.awssdk.services.iotwireless.model.EventNotificationTopicStatus.ENABLED
  }
  case object Disabled
      extends zio.aws.iotwireless.model.EventNotificationTopicStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.EventNotificationTopicStatus =
      software.amazon.awssdk.services.iotwireless.model.EventNotificationTopicStatus.DISABLED
  }
}
