package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{WirelessDeviceId, MulticastGroupId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateWirelessDeviceFromMulticastGroupRequest(
    id: MulticastGroupId,
    wirelessDeviceId: WirelessDeviceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromMulticastGroupRequest = {
    import DisassociateWirelessDeviceFromMulticastGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromMulticastGroupRequest
      .builder()
      .id(MulticastGroupId.unwrap(id): java.lang.String)
      .wirelessDeviceId(
        WirelessDeviceId.unwrap(wirelessDeviceId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.DisassociateWirelessDeviceFromMulticastGroupRequest.ReadOnly =
    zio.aws.iotwireless.model.DisassociateWirelessDeviceFromMulticastGroupRequest
      .wrap(buildAwsValue())
}
object DisassociateWirelessDeviceFromMulticastGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromMulticastGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.DisassociateWirelessDeviceFromMulticastGroupRequest =
      zio.aws.iotwireless.model
        .DisassociateWirelessDeviceFromMulticastGroupRequest(
          id,
          wirelessDeviceId
        )
    def id: MulticastGroupId
    def wirelessDeviceId: WirelessDeviceId
    def getId: ZIO[Any, Nothing, MulticastGroupId] = ZIO.succeed(id)
    def getWirelessDeviceId: ZIO[Any, Nothing, WirelessDeviceId] =
      ZIO.succeed(wirelessDeviceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromMulticastGroupRequest
  ) extends zio.aws.iotwireless.model.DisassociateWirelessDeviceFromMulticastGroupRequest.ReadOnly {
    override val id: MulticastGroupId =
      zio.aws.iotwireless.model.primitives.MulticastGroupId(impl.id())
    override val wirelessDeviceId: WirelessDeviceId =
      zio.aws.iotwireless.model.primitives
        .WirelessDeviceId(impl.wirelessDeviceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromMulticastGroupRequest
  ): zio.aws.iotwireless.model.DisassociateWirelessDeviceFromMulticastGroupRequest.ReadOnly =
    new Wrapper(impl)
}
