package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{WirelessDeviceId, FuotaTaskId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateWirelessDeviceFromFuotaTaskRequest(
    id: FuotaTaskId,
    wirelessDeviceId: WirelessDeviceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromFuotaTaskRequest = {
    import DisassociateWirelessDeviceFromFuotaTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromFuotaTaskRequest
      .builder()
      .id(FuotaTaskId.unwrap(id): java.lang.String)
      .wirelessDeviceId(
        WirelessDeviceId.unwrap(wirelessDeviceId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.DisassociateWirelessDeviceFromFuotaTaskRequest.ReadOnly =
    zio.aws.iotwireless.model.DisassociateWirelessDeviceFromFuotaTaskRequest
      .wrap(buildAwsValue())
}
object DisassociateWirelessDeviceFromFuotaTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromFuotaTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.DisassociateWirelessDeviceFromFuotaTaskRequest =
      zio.aws.iotwireless.model
        .DisassociateWirelessDeviceFromFuotaTaskRequest(id, wirelessDeviceId)
    def id: FuotaTaskId
    def wirelessDeviceId: WirelessDeviceId
    def getId: ZIO[Any, Nothing, FuotaTaskId] = ZIO.succeed(id)
    def getWirelessDeviceId: ZIO[Any, Nothing, WirelessDeviceId] =
      ZIO.succeed(wirelessDeviceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromFuotaTaskRequest
  ) extends zio.aws.iotwireless.model.DisassociateWirelessDeviceFromFuotaTaskRequest.ReadOnly {
    override val id: FuotaTaskId =
      zio.aws.iotwireless.model.primitives.FuotaTaskId(impl.id())
    override val wirelessDeviceId: WirelessDeviceId =
      zio.aws.iotwireless.model.primitives
        .WirelessDeviceId(impl.wirelessDeviceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromFuotaTaskRequest
  ): zio.aws.iotwireless.model.DisassociateWirelessDeviceFromFuotaTaskRequest.ReadOnly =
    new Wrapper(impl)
}
