package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  RoleArn,
  Expression,
  Description,
  DestinationArn,
  DestinationName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Destinations(
    arn: Optional[DestinationArn] = Optional.Absent,
    name: Optional[DestinationName] = Optional.Absent,
    expressionType: Optional[zio.aws.iotwireless.model.ExpressionType] =
      Optional.Absent,
    expression: Optional[Expression] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.Destinations = {
    import Destinations.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.Destinations
      .builder()
      .optionallyWith(
        arn.map(value => DestinationArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => DestinationName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(expressionType.map(value => value.unwrap))(
        _.expressionType
      )
      .optionallyWith(
        expression.map(value => Expression.unwrap(value): java.lang.String)
      )(_.expression)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.Destinations.ReadOnly =
    zio.aws.iotwireless.model.Destinations.wrap(buildAwsValue())
}
object Destinations {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.Destinations
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.Destinations =
      zio.aws.iotwireless.model.Destinations(
        arn.map(value => value),
        name.map(value => value),
        expressionType.map(value => value),
        expression.map(value => value),
        description.map(value => value),
        roleArn.map(value => value)
      )
    def arn: Optional[DestinationArn]
    def name: Optional[DestinationName]
    def expressionType: Optional[zio.aws.iotwireless.model.ExpressionType]
    def expression: Optional[Expression]
    def description: Optional[Description]
    def roleArn: Optional[RoleArn]
    def getArn: ZIO[Any, AwsError, DestinationArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, DestinationName] =
      AwsError.unwrapOptionField("name", name)
    def getExpressionType
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.ExpressionType] =
      AwsError.unwrapOptionField("expressionType", expressionType)
    def getExpression: ZIO[Any, AwsError, Expression] =
      AwsError.unwrapOptionField("expression", expression)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.Destinations
  ) extends zio.aws.iotwireless.model.Destinations.ReadOnly {
    override val arn: Optional[DestinationArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.iotwireless.model.primitives.DestinationArn(value))
    override val name: Optional[DestinationName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.iotwireless.model.primitives.DestinationName(value))
    override val expressionType
        : Optional[zio.aws.iotwireless.model.ExpressionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expressionType())
        .map(value => zio.aws.iotwireless.model.ExpressionType.wrap(value))
    override val expression: Optional[Expression] = zio.aws.core.internal
      .optionalFromNullable(impl.expression())
      .map(value => zio.aws.iotwireless.model.primitives.Expression(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.iotwireless.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.Destinations
  ): zio.aws.iotwireless.model.Destinations.ReadOnly = new Wrapper(impl)
}
