package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.WirelessGatewayTaskDefinitionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteWirelessGatewayTaskDefinitionRequest(
    id: WirelessGatewayTaskDefinitionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskDefinitionRequest = {
    import DeleteWirelessGatewayTaskDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskDefinitionRequest
      .builder()
      .id(WirelessGatewayTaskDefinitionId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.DeleteWirelessGatewayTaskDefinitionRequest.ReadOnly =
    zio.aws.iotwireless.model.DeleteWirelessGatewayTaskDefinitionRequest
      .wrap(buildAwsValue())
}
object DeleteWirelessGatewayTaskDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.DeleteWirelessGatewayTaskDefinitionRequest =
      zio.aws.iotwireless.model.DeleteWirelessGatewayTaskDefinitionRequest(id)
    def id: WirelessGatewayTaskDefinitionId
    def getId: ZIO[Any, Nothing, WirelessGatewayTaskDefinitionId] =
      ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskDefinitionRequest
  ) extends zio.aws.iotwireless.model.DeleteWirelessGatewayTaskDefinitionRequest.ReadOnly {
    override val id: WirelessGatewayTaskDefinitionId =
      zio.aws.iotwireless.model.primitives
        .WirelessGatewayTaskDefinitionId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskDefinitionRequest
  ): zio.aws.iotwireless.model.DeleteWirelessGatewayTaskDefinitionRequest.ReadOnly =
    new Wrapper(impl)
}
