package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{MessageId, WirelessDeviceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteQueuedMessagesRequest(
    id: WirelessDeviceId,
    messageId: MessageId,
    wirelessDeviceType: Optional[zio.aws.iotwireless.model.WirelessDeviceType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.DeleteQueuedMessagesRequest = {
    import DeleteQueuedMessagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.DeleteQueuedMessagesRequest
      .builder()
      .id(WirelessDeviceId.unwrap(id): java.lang.String)
      .messageId(MessageId.unwrap(messageId): java.lang.String)
      .optionallyWith(wirelessDeviceType.map(value => value.unwrap))(
        _.wirelessDeviceType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.DeleteQueuedMessagesRequest.ReadOnly =
    zio.aws.iotwireless.model.DeleteQueuedMessagesRequest.wrap(buildAwsValue())
}
object DeleteQueuedMessagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.DeleteQueuedMessagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.DeleteQueuedMessagesRequest =
      zio.aws.iotwireless.model.DeleteQueuedMessagesRequest(
        id,
        messageId,
        wirelessDeviceType.map(value => value)
      )
    def id: WirelessDeviceId
    def messageId: MessageId
    def wirelessDeviceType
        : Optional[zio.aws.iotwireless.model.WirelessDeviceType]
    def getId: ZIO[Any, Nothing, WirelessDeviceId] = ZIO.succeed(id)
    def getMessageId: ZIO[Any, Nothing, MessageId] = ZIO.succeed(messageId)
    def getWirelessDeviceType
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.WirelessDeviceType] =
      AwsError.unwrapOptionField("wirelessDeviceType", wirelessDeviceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.DeleteQueuedMessagesRequest
  ) extends zio.aws.iotwireless.model.DeleteQueuedMessagesRequest.ReadOnly {
    override val id: WirelessDeviceId =
      zio.aws.iotwireless.model.primitives.WirelessDeviceId(impl.id())
    override val messageId: MessageId =
      zio.aws.iotwireless.model.primitives.MessageId(impl.messageId())
    override val wirelessDeviceType
        : Optional[zio.aws.iotwireless.model.WirelessDeviceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.wirelessDeviceType())
        .map(value => zio.aws.iotwireless.model.WirelessDeviceType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.DeleteQueuedMessagesRequest
  ): zio.aws.iotwireless.model.DeleteQueuedMessagesRequest.ReadOnly =
    new Wrapper(impl)
}
