package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  ClientRequestToken,
  WirelessGatewayTaskName,
  AutoCreateTasks
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateWirelessGatewayTaskDefinitionRequest(
    autoCreateTasks: AutoCreateTasks,
    name: Optional[WirelessGatewayTaskName] = Optional.Absent,
    update: Optional[
      zio.aws.iotwireless.model.UpdateWirelessGatewayTaskCreate
    ] = Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.iotwireless.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionRequest = {
    import CreateWirelessGatewayTaskDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionRequest
      .builder()
      .autoCreateTasks(
        AutoCreateTasks.unwrap(autoCreateTasks): java.lang.Boolean
      )
      .optionallyWith(
        name.map(value =>
          WirelessGatewayTaskName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(update.map(value => value.buildAwsValue()))(_.update)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.CreateWirelessGatewayTaskDefinitionRequest.ReadOnly =
    zio.aws.iotwireless.model.CreateWirelessGatewayTaskDefinitionRequest
      .wrap(buildAwsValue())
}
object CreateWirelessGatewayTaskDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.CreateWirelessGatewayTaskDefinitionRequest =
      zio.aws.iotwireless.model.CreateWirelessGatewayTaskDefinitionRequest(
        autoCreateTasks,
        name.map(value => value),
        update.map(value => value.asEditable),
        clientRequestToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def autoCreateTasks: AutoCreateTasks
    def name: Optional[WirelessGatewayTaskName]
    def update: Optional[
      zio.aws.iotwireless.model.UpdateWirelessGatewayTaskCreate.ReadOnly
    ]
    def clientRequestToken: Optional[ClientRequestToken]
    def tags: Optional[List[zio.aws.iotwireless.model.Tag.ReadOnly]]
    def getAutoCreateTasks: ZIO[Any, Nothing, AutoCreateTasks] =
      ZIO.succeed(autoCreateTasks)
    def getName: ZIO[Any, AwsError, WirelessGatewayTaskName] =
      AwsError.unwrapOptionField("name", name)
    def getUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.UpdateWirelessGatewayTaskCreate.ReadOnly
    ] = AwsError.unwrapOptionField("update", update)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionRequest
  ) extends zio.aws.iotwireless.model.CreateWirelessGatewayTaskDefinitionRequest.ReadOnly {
    override val autoCreateTasks: AutoCreateTasks =
      zio.aws.iotwireless.model.primitives
        .AutoCreateTasks(impl.autoCreateTasks())
    override val name: Optional[WirelessGatewayTaskName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessGatewayTaskName(value)
      )
    override val update: Optional[
      zio.aws.iotwireless.model.UpdateWirelessGatewayTaskCreate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.update())
      .map(value =>
        zio.aws.iotwireless.model.UpdateWirelessGatewayTaskCreate.wrap(value)
      )
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.iotwireless.model.primitives.ClientRequestToken(value)
        )
    override val tags: Optional[List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionRequest
  ): zio.aws.iotwireless.model.CreateWirelessGatewayTaskDefinitionRequest.ReadOnly =
    new Wrapper(impl)
}
