package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  WirelessDeviceId,
  WirelessGatewayArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateWirelessGatewayResponse(
    arn: Optional[WirelessGatewayArn] = Optional.Absent,
    id: Optional[WirelessDeviceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayResponse = {
    import CreateWirelessGatewayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayResponse
      .builder()
      .optionallyWith(
        arn.map(value => WirelessGatewayArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        id.map(value => WirelessDeviceId.unwrap(value): java.lang.String)
      )(_.id)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.CreateWirelessGatewayResponse.ReadOnly =
    zio.aws.iotwireless.model.CreateWirelessGatewayResponse
      .wrap(buildAwsValue())
}
object CreateWirelessGatewayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.CreateWirelessGatewayResponse =
      zio.aws.iotwireless.model.CreateWirelessGatewayResponse(
        arn.map(value => value),
        id.map(value => value)
      )
    def arn: Optional[WirelessGatewayArn]
    def id: Optional[WirelessDeviceId]
    def getArn: ZIO[Any, AwsError, WirelessGatewayArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, WirelessDeviceId] =
      AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayResponse
  ) extends zio.aws.iotwireless.model.CreateWirelessGatewayResponse.ReadOnly {
    override val arn: Optional[WirelessGatewayArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessGatewayArn(value)
      )
    override val id: Optional[WirelessDeviceId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessDeviceId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayResponse
  ): zio.aws.iotwireless.model.CreateWirelessGatewayResponse.ReadOnly =
    new Wrapper(impl)
}
