package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  WirelessGatewayId,
  ClientRequestToken,
  NetworkAnalyzerConfigurationName,
  Description,
  WirelessDeviceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateNetworkAnalyzerConfigurationRequest(
    name: NetworkAnalyzerConfigurationName,
    traceContent: Optional[zio.aws.iotwireless.model.TraceContent] =
      Optional.Absent,
    wirelessDevices: Optional[Iterable[WirelessDeviceId]] = Optional.Absent,
    wirelessGateways: Optional[Iterable[WirelessGatewayId]] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.iotwireless.model.Tag]] = Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CreateNetworkAnalyzerConfigurationRequest = {
    import CreateNetworkAnalyzerConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CreateNetworkAnalyzerConfigurationRequest
      .builder()
      .name(NetworkAnalyzerConfigurationName.unwrap(name): java.lang.String)
      .optionallyWith(traceContent.map(value => value.buildAwsValue()))(
        _.traceContent
      )
      .optionallyWith(
        wirelessDevices.map(value =>
          value.map { item =>
            WirelessDeviceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.wirelessDevices)
      .optionallyWith(
        wirelessGateways.map(value =>
          value.map { item =>
            WirelessGatewayId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.wirelessGateways)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.CreateNetworkAnalyzerConfigurationRequest.ReadOnly =
    zio.aws.iotwireless.model.CreateNetworkAnalyzerConfigurationRequest
      .wrap(buildAwsValue())
}
object CreateNetworkAnalyzerConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CreateNetworkAnalyzerConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.CreateNetworkAnalyzerConfigurationRequest =
      zio.aws.iotwireless.model.CreateNetworkAnalyzerConfigurationRequest(
        name,
        traceContent.map(value => value.asEditable),
        wirelessDevices.map(value => value),
        wirelessGateways.map(value => value),
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientRequestToken.map(value => value)
      )
    def name: NetworkAnalyzerConfigurationName
    def traceContent: Optional[zio.aws.iotwireless.model.TraceContent.ReadOnly]
    def wirelessDevices: Optional[List[WirelessDeviceId]]
    def wirelessGateways: Optional[List[WirelessGatewayId]]
    def description: Optional[Description]
    def tags: Optional[List[zio.aws.iotwireless.model.Tag.ReadOnly]]
    def clientRequestToken: Optional[ClientRequestToken]
    def getName: ZIO[Any, Nothing, NetworkAnalyzerConfigurationName] =
      ZIO.succeed(name)
    def getTraceContent
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.TraceContent.ReadOnly] =
      AwsError.unwrapOptionField("traceContent", traceContent)
    def getWirelessDevices: ZIO[Any, AwsError, List[WirelessDeviceId]] =
      AwsError.unwrapOptionField("wirelessDevices", wirelessDevices)
    def getWirelessGateways: ZIO[Any, AwsError, List[WirelessGatewayId]] =
      AwsError.unwrapOptionField("wirelessGateways", wirelessGateways)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateNetworkAnalyzerConfigurationRequest
  ) extends zio.aws.iotwireless.model.CreateNetworkAnalyzerConfigurationRequest.ReadOnly {
    override val name: NetworkAnalyzerConfigurationName =
      zio.aws.iotwireless.model.primitives
        .NetworkAnalyzerConfigurationName(impl.name())
    override val traceContent
        : Optional[zio.aws.iotwireless.model.TraceContent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.traceContent())
        .map(value => zio.aws.iotwireless.model.TraceContent.wrap(value))
    override val wirelessDevices: Optional[List[WirelessDeviceId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.wirelessDevices())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.primitives.WirelessDeviceId(item)
          }.toList
        )
    override val wirelessGateways: Optional[List[WirelessGatewayId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.wirelessGateways())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.primitives.WirelessGatewayId(item)
          }.toList
        )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val tags: Optional[List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.Tag.wrap(item)
          }.toList
        )
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.iotwireless.model.primitives.ClientRequestToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateNetworkAnalyzerConfigurationRequest
  ): zio.aws.iotwireless.model.CreateNetworkAnalyzerConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
