package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{DestinationName, DestinationArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDestinationResponse(
    arn: Optional[DestinationArn] = Optional.Absent,
    name: Optional[DestinationName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CreateDestinationResponse = {
    import CreateDestinationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CreateDestinationResponse
      .builder()
      .optionallyWith(
        arn.map(value => DestinationArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => DestinationName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.CreateDestinationResponse.ReadOnly =
    zio.aws.iotwireless.model.CreateDestinationResponse.wrap(buildAwsValue())
}
object CreateDestinationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CreateDestinationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.CreateDestinationResponse =
      zio.aws.iotwireless.model.CreateDestinationResponse(
        arn.map(value => value),
        name.map(value => value)
      )
    def arn: Optional[DestinationArn]
    def name: Optional[DestinationName]
    def getArn: ZIO[Any, AwsError, DestinationArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, DestinationName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateDestinationResponse
  ) extends zio.aws.iotwireless.model.CreateDestinationResponse.ReadOnly {
    override val arn: Optional[DestinationArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.iotwireless.model.primitives.DestinationArn(value))
    override val name: Optional[DestinationName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.iotwireless.model.primitives.DestinationName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateDestinationResponse
  ): zio.aws.iotwireless.model.CreateDestinationResponse.ReadOnly = new Wrapper(
    impl
  )
}
