package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConnectionStatusResourceTypeEventConfiguration(
    loRaWAN: Optional[
      zio.aws.iotwireless.model.LoRaWANConnectionStatusResourceTypeEventConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ConnectionStatusResourceTypeEventConfiguration = {
    import ConnectionStatusResourceTypeEventConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ConnectionStatusResourceTypeEventConfiguration
      .builder()
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ConnectionStatusResourceTypeEventConfiguration.ReadOnly =
    zio.aws.iotwireless.model.ConnectionStatusResourceTypeEventConfiguration
      .wrap(buildAwsValue())
}
object ConnectionStatusResourceTypeEventConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ConnectionStatusResourceTypeEventConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.ConnectionStatusResourceTypeEventConfiguration =
      zio.aws.iotwireless.model.ConnectionStatusResourceTypeEventConfiguration(
        loRaWAN.map(value => value.asEditable)
      )
    def loRaWAN: Optional[
      zio.aws.iotwireless.model.LoRaWANConnectionStatusResourceTypeEventConfiguration.ReadOnly
    ]
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANConnectionStatusResourceTypeEventConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ConnectionStatusResourceTypeEventConfiguration
  ) extends zio.aws.iotwireless.model.ConnectionStatusResourceTypeEventConfiguration.ReadOnly {
    override val loRaWAN: Optional[
      zio.aws.iotwireless.model.LoRaWANConnectionStatusResourceTypeEventConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.loRaWAN())
      .map(value =>
        zio.aws.iotwireless.model.LoRaWANConnectionStatusResourceTypeEventConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ConnectionStatusResourceTypeEventConfiguration
  ): zio.aws.iotwireless.model.ConnectionStatusResourceTypeEventConfiguration.ReadOnly =
    new Wrapper(impl)
}
