package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.IotCertificateId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateWirelessGatewayWithCertificateResponse(
    iotCertificateId: Optional[IotCertificateId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithCertificateResponse = {
    import AssociateWirelessGatewayWithCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithCertificateResponse
      .builder()
      .optionallyWith(
        iotCertificateId.map(value =>
          IotCertificateId.unwrap(value): java.lang.String
        )
      )(_.iotCertificateId)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.AssociateWirelessGatewayWithCertificateResponse.ReadOnly =
    zio.aws.iotwireless.model.AssociateWirelessGatewayWithCertificateResponse
      .wrap(buildAwsValue())
}
object AssociateWirelessGatewayWithCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.AssociateWirelessGatewayWithCertificateResponse =
      zio.aws.iotwireless.model.AssociateWirelessGatewayWithCertificateResponse(
        iotCertificateId.map(value => value)
      )
    def iotCertificateId: Optional[IotCertificateId]
    def getIotCertificateId: ZIO[Any, AwsError, IotCertificateId] =
      AwsError.unwrapOptionField("iotCertificateId", iotCertificateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithCertificateResponse
  ) extends zio.aws.iotwireless.model.AssociateWirelessGatewayWithCertificateResponse.ReadOnly {
    override val iotCertificateId: Optional[IotCertificateId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iotCertificateId())
        .map(value =>
          zio.aws.iotwireless.model.primitives.IotCertificateId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithCertificateResponse
  ): zio.aws.iotwireless.model.AssociateWirelessGatewayWithCertificateResponse.ReadOnly =
    new Wrapper(impl)
}
