package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{FCntStart, DevAddr}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class AbpV1_1(
    devAddr: Optional[DevAddr] = Optional.Absent,
    sessionKeys: Optional[zio.aws.iotwireless.model.SessionKeysAbpV1_1] =
      Optional.Absent,
    fCntStart: Optional[FCntStart] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.AbpV1_1 = {
    import AbpV1_1.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.AbpV1_1
      .builder()
      .optionallyWith(
        devAddr.map(value => DevAddr.unwrap(value): java.lang.String)
      )(_.devAddr)
      .optionallyWith(sessionKeys.map(value => value.buildAwsValue()))(
        _.sessionKeys
      )
      .optionallyWith(fCntStart.map(value => FCntStart.unwrap(value): Integer))(
        _.fCntStart
      )
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.AbpV1_1.ReadOnly =
    zio.aws.iotwireless.model.AbpV1_1.wrap(buildAwsValue())
}
object AbpV1_1 {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.AbpV1_1
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.AbpV1_1 =
      zio.aws.iotwireless.model.AbpV1_1(
        devAddr.map(value => value),
        sessionKeys.map(value => value.asEditable),
        fCntStart.map(value => value)
      )
    def devAddr: Optional[DevAddr]
    def sessionKeys
        : Optional[zio.aws.iotwireless.model.SessionKeysAbpV1_1.ReadOnly]
    def fCntStart: Optional[FCntStart]
    def getDevAddr: ZIO[Any, AwsError, DevAddr] =
      AwsError.unwrapOptionField("devAddr", devAddr)
    def getSessionKeys: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.SessionKeysAbpV1_1.ReadOnly
    ] = AwsError.unwrapOptionField("sessionKeys", sessionKeys)
    def getFCntStart: ZIO[Any, AwsError, FCntStart] =
      AwsError.unwrapOptionField("fCntStart", fCntStart)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.AbpV1_1
  ) extends zio.aws.iotwireless.model.AbpV1_1.ReadOnly {
    override val devAddr: Optional[DevAddr] = zio.aws.core.internal
      .optionalFromNullable(impl.devAddr())
      .map(value => zio.aws.iotwireless.model.primitives.DevAddr(value))
    override val sessionKeys
        : Optional[zio.aws.iotwireless.model.SessionKeysAbpV1_1.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionKeys())
        .map(value => zio.aws.iotwireless.model.SessionKeysAbpV1_1.wrap(value))
    override val fCntStart: Optional[FCntStart] = zio.aws.core.internal
      .optionalFromNullable(impl.fCntStart())
      .map(value => zio.aws.iotwireless.model.primitives.FCntStart(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.AbpV1_1
  ): zio.aws.iotwireless.model.AbpV1_1.ReadOnly = new Wrapper(impl)
}
