package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{FCntStart, DevAddr}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class AbpV1_0_x(
    devAddr: Optional[DevAddr] = Optional.Absent,
    sessionKeys: Optional[zio.aws.iotwireless.model.SessionKeysAbpV1_0_x] =
      Optional.Absent,
    fCntStart: Optional[FCntStart] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.AbpV1_0_x = {
    import AbpV1_0_x.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.AbpV1_0_x
      .builder()
      .optionallyWith(
        devAddr.map(value => DevAddr.unwrap(value): java.lang.String)
      )(_.devAddr)
      .optionallyWith(sessionKeys.map(value => value.buildAwsValue()))(
        _.sessionKeys
      )
      .optionallyWith(fCntStart.map(value => FCntStart.unwrap(value): Integer))(
        _.fCntStart
      )
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.AbpV1_0_x.ReadOnly =
    zio.aws.iotwireless.model.AbpV1_0_x.wrap(buildAwsValue())
}
object AbpV1_0_x {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.AbpV1_0_x
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.AbpV1_0_x =
      zio.aws.iotwireless.model.AbpV1_0_x(
        devAddr.map(value => value),
        sessionKeys.map(value => value.asEditable),
        fCntStart.map(value => value)
      )
    def devAddr: Optional[DevAddr]
    def sessionKeys
        : Optional[zio.aws.iotwireless.model.SessionKeysAbpV1_0_x.ReadOnly]
    def fCntStart: Optional[FCntStart]
    def getDevAddr: ZIO[Any, AwsError, DevAddr] =
      AwsError.unwrapOptionField("devAddr", devAddr)
    def getSessionKeys: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.SessionKeysAbpV1_0_x.ReadOnly
    ] = AwsError.unwrapOptionField("sessionKeys", sessionKeys)
    def getFCntStart: ZIO[Any, AwsError, FCntStart] =
      AwsError.unwrapOptionField("fCntStart", fCntStart)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.AbpV1_0_x
  ) extends zio.aws.iotwireless.model.AbpV1_0_x.ReadOnly {
    override val devAddr: Optional[DevAddr] = zio.aws.core.internal
      .optionalFromNullable(impl.devAddr())
      .map(value => zio.aws.iotwireless.model.primitives.DevAddr(value))
    override val sessionKeys
        : Optional[zio.aws.iotwireless.model.SessionKeysAbpV1_0_x.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionKeys())
        .map(value =>
          zio.aws.iotwireless.model.SessionKeysAbpV1_0_x.wrap(value)
        )
    override val fCntStart: Optional[FCntStart] = zio.aws.core.internal
      .optionalFromNullable(impl.fCntStart())
      .map(value => zio.aws.iotwireless.model.primitives.FCntStart(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.AbpV1_0_x
  ): zio.aws.iotwireless.model.AbpV1_0_x.ReadOnly = new Wrapper(impl)
}
