package zio.aws.iotwireless
import zio.aws.iotwireless.model.primitives.{
  SubBand,
  WirelessGatewayId,
  NetId,
  PresetFreq,
  JoinEui,
  WirelessDeviceId,
  TagKey
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.iotwireless.model.primitives.MulticastGroupId.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AccountLinked extends Subtype[Boolean]
    type AccountLinked = zio.aws.iotwireless.model.primitives.AccountLinked.Type
    object AddGwMetadata extends Subtype[Boolean]
    type AddGwMetadata = zio.aws.iotwireless.model.primitives.AddGwMetadata.Type
    object AmazonId extends Subtype[String]
    type AmazonId = zio.aws.iotwireless.model.primitives.AmazonId.Type
    object AmazonResourceName extends Subtype[String]
    type AmazonResourceName =
      zio.aws.iotwireless.model.primitives.AmazonResourceName.Type
    object AppEui extends Subtype[String]
    type AppEui = zio.aws.iotwireless.model.primitives.AppEui.Type
    object AppKey extends Subtype[String]
    type AppKey = zio.aws.iotwireless.model.primitives.AppKey.Type
    object AppSKey extends Subtype[String]
    type AppSKey = zio.aws.iotwireless.model.primitives.AppSKey.Type
    object AppServerPrivateKey extends Subtype[String]
    type AppServerPrivateKey =
      zio.aws.iotwireless.model.primitives.AppServerPrivateKey.Type
    object AutoCreateTasks extends Subtype[Boolean]
    type AutoCreateTasks =
      zio.aws.iotwireless.model.primitives.AutoCreateTasks.Type
    object CertificatePEM extends Subtype[String]
    type CertificatePEM =
      zio.aws.iotwireless.model.primitives.CertificatePEM.Type
    object CertificateValue extends Subtype[String]
    type CertificateValue =
      zio.aws.iotwireless.model.primitives.CertificateValue.Type
    object ChannelMask extends Subtype[String]
    type ChannelMask = zio.aws.iotwireless.model.primitives.ChannelMask.Type
    object ClassBTimeout extends Subtype[Int]
    type ClassBTimeout = zio.aws.iotwireless.model.primitives.ClassBTimeout.Type
    object ClassCTimeout extends Subtype[Int]
    type ClassCTimeout = zio.aws.iotwireless.model.primitives.ClassCTimeout.Type
    object ClientRequestToken extends Subtype[String]
    type ClientRequestToken =
      zio.aws.iotwireless.model.primitives.ClientRequestToken.Type
    object Crc extends Subtype[Long]
    type Crc = zio.aws.iotwireless.model.primitives.Crc.Type
    object CreatedAt extends Subtype[Instant]
    type CreatedAt = zio.aws.iotwireless.model.primitives.CreatedAt.Type
    object Description extends Subtype[String]
    type Description = zio.aws.iotwireless.model.primitives.Description.Type
    object DestinationArn extends Subtype[String]
    type DestinationArn =
      zio.aws.iotwireless.model.primitives.DestinationArn.Type
    object DestinationName extends Subtype[String]
    type DestinationName =
      zio.aws.iotwireless.model.primitives.DestinationName.Type
    object DevAddr extends Subtype[String]
    type DevAddr = zio.aws.iotwireless.model.primitives.DevAddr.Type
    object DevEui extends Subtype[String]
    type DevEui = zio.aws.iotwireless.model.primitives.DevEui.Type
    object DevStatusReqFreq extends Subtype[Int]
    type DevStatusReqFreq =
      zio.aws.iotwireless.model.primitives.DevStatusReqFreq.Type
    object DeviceProfileArn extends Subtype[String]
    type DeviceProfileArn =
      zio.aws.iotwireless.model.primitives.DeviceProfileArn.Type
    object DeviceProfileId extends Subtype[String]
    type DeviceProfileId =
      zio.aws.iotwireless.model.primitives.DeviceProfileId.Type
    object DeviceProfileName extends Subtype[String]
    type DeviceProfileName =
      zio.aws.iotwireless.model.primitives.DeviceProfileName.Type
    object DlBucketSize extends Subtype[Int]
    type DlBucketSize = zio.aws.iotwireless.model.primitives.DlBucketSize.Type
    object DlDr extends Subtype[Int]
    type DlDr = zio.aws.iotwireless.model.primitives.DlDr.Type
    object DlFreq extends Subtype[Int]
    type DlFreq = zio.aws.iotwireless.model.primitives.DlFreq.Type
    object DlRate extends Subtype[Int]
    type DlRate = zio.aws.iotwireless.model.primitives.DlRate.Type
    object DlRatePolicy extends Subtype[String]
    type DlRatePolicy = zio.aws.iotwireless.model.primitives.DlRatePolicy.Type
    object DrMax extends Subtype[Int]
    type DrMax = zio.aws.iotwireless.model.primitives.DrMax.Type
    object DrMin extends Subtype[Int]
    type DrMin = zio.aws.iotwireless.model.primitives.DrMin.Type
    object EndPoint extends Subtype[String]
    type EndPoint = zio.aws.iotwireless.model.primitives.EndPoint.Type
    object Expression extends Subtype[String]
    type Expression = zio.aws.iotwireless.model.primitives.Expression.Type
    object FNwkSIntKey extends Subtype[String]
    type FNwkSIntKey = zio.aws.iotwireless.model.primitives.FNwkSIntKey.Type
    object FPort extends Subtype[Int]
    type FPort = zio.aws.iotwireless.model.primitives.FPort.Type
    object Fingerprint extends Subtype[String]
    type Fingerprint = zio.aws.iotwireless.model.primitives.Fingerprint.Type
    object FirmwareUpdateImage extends Subtype[String]
    type FirmwareUpdateImage =
      zio.aws.iotwireless.model.primitives.FirmwareUpdateImage.Type
    object FirmwareUpdateRole extends Subtype[String]
    type FirmwareUpdateRole =
      zio.aws.iotwireless.model.primitives.FirmwareUpdateRole.Type
    object FuotaTaskArn extends Subtype[String]
    type FuotaTaskArn = zio.aws.iotwireless.model.primitives.FuotaTaskArn.Type
    object FuotaTaskId extends Subtype[String]
    type FuotaTaskId = zio.aws.iotwireless.model.primitives.FuotaTaskId.Type
    object FuotaTaskName extends Subtype[String]
    type FuotaTaskName = zio.aws.iotwireless.model.primitives.FuotaTaskName.Type
    object GatewayEui extends Subtype[String]
    type GatewayEui = zio.aws.iotwireless.model.primitives.GatewayEui.Type
    object GenAppKey extends Subtype[String]
    type GenAppKey = zio.aws.iotwireless.model.primitives.GenAppKey.Type
    object HrAllowed extends Subtype[Boolean]
    type HrAllowed = zio.aws.iotwireless.model.primitives.HrAllowed.Type
    object ISODateTimeString extends Subtype[String]
    type ISODateTimeString =
      zio.aws.iotwireless.model.primitives.ISODateTimeString.Type
    object Identifier extends Subtype[String]
    type Identifier = zio.aws.iotwireless.model.primitives.Identifier.Type
    type Integer = Int
    object IotCertificateId extends Subtype[String]
    type IotCertificateId =
      zio.aws.iotwireless.model.primitives.IotCertificateId.Type
    object JoinEui extends Subtype[String]
    type JoinEui = zio.aws.iotwireless.model.primitives.JoinEui.Type
    object MacVersion extends Subtype[String]
    type MacVersion = zio.aws.iotwireless.model.primitives.MacVersion.Type
    object MaxDutyCycle extends Subtype[Int]
    type MaxDutyCycle = zio.aws.iotwireless.model.primitives.MaxDutyCycle.Type
    object MaxEirp extends Subtype[Int]
    type MaxEirp = zio.aws.iotwireless.model.primitives.MaxEirp.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.iotwireless.model.primitives.MaxResults.Type
    object McGroupId extends Subtype[Int]
    type McGroupId = zio.aws.iotwireless.model.primitives.McGroupId.Type
    object MessageId extends Subtype[String]
    type MessageId = zio.aws.iotwireless.model.primitives.MessageId.Type
    object MinGwDiversity extends Subtype[Int]
    type MinGwDiversity =
      zio.aws.iotwireless.model.primitives.MinGwDiversity.Type
    object Model extends Subtype[String]
    type Model = zio.aws.iotwireless.model.primitives.Model.Type
    object MulticastDeviceStatus extends Subtype[String]
    type MulticastDeviceStatus =
      zio.aws.iotwireless.model.primitives.MulticastDeviceStatus.Type
    object MulticastGroupArn extends Subtype[String]
    type MulticastGroupArn =
      zio.aws.iotwireless.model.primitives.MulticastGroupArn.Type
    object MulticastGroupId extends Subtype[String]
    type MulticastGroupId =
      zio.aws.iotwireless.model.primitives.MulticastGroupId.Type
    object MulticastGroupMessageId extends Subtype[String]
    type MulticastGroupMessageId =
      zio.aws.iotwireless.model.primitives.MulticastGroupMessageId.Type
    object MulticastGroupName extends Subtype[String]
    type MulticastGroupName =
      zio.aws.iotwireless.model.primitives.MulticastGroupName.Type
    object MulticastGroupStatus extends Subtype[String]
    type MulticastGroupStatus =
      zio.aws.iotwireless.model.primitives.MulticastGroupStatus.Type
    object NetId extends Subtype[String]
    type NetId = zio.aws.iotwireless.model.primitives.NetId.Type
    object NetworkAnalyzerConfigurationName extends Subtype[String]
    type NetworkAnalyzerConfigurationName =
      zio.aws.iotwireless.model.primitives.NetworkAnalyzerConfigurationName.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.iotwireless.model.primitives.NextToken.Type
    object NumberOfDevicesInGroup extends Subtype[Int]
    type NumberOfDevicesInGroup =
      zio.aws.iotwireless.model.primitives.NumberOfDevicesInGroup.Type
    object NumberOfDevicesRequested extends Subtype[Int]
    type NumberOfDevicesRequested =
      zio.aws.iotwireless.model.primitives.NumberOfDevicesRequested.Type
    object NwkGeoLoc extends Subtype[Boolean]
    type NwkGeoLoc = zio.aws.iotwireless.model.primitives.NwkGeoLoc.Type
    object NwkKey extends Subtype[String]
    type NwkKey = zio.aws.iotwireless.model.primitives.NwkKey.Type
    object NwkSEncKey extends Subtype[String]
    type NwkSEncKey = zio.aws.iotwireless.model.primitives.NwkSEncKey.Type
    object NwkSKey extends Subtype[String]
    type NwkSKey = zio.aws.iotwireless.model.primitives.NwkSKey.Type
    object PackageVersion extends Subtype[String]
    type PackageVersion =
      zio.aws.iotwireless.model.primitives.PackageVersion.Type
    object PartnerAccountArn extends Subtype[String]
    type PartnerAccountArn =
      zio.aws.iotwireless.model.primitives.PartnerAccountArn.Type
    object PartnerAccountId extends Subtype[String]
    type PartnerAccountId =
      zio.aws.iotwireless.model.primitives.PartnerAccountId.Type
    object PayloadData extends Subtype[String]
    type PayloadData = zio.aws.iotwireless.model.primitives.PayloadData.Type
    object PingSlotDr extends Subtype[Int]
    type PingSlotDr = zio.aws.iotwireless.model.primitives.PingSlotDr.Type
    object PingSlotFreq extends Subtype[Int]
    type PingSlotFreq = zio.aws.iotwireless.model.primitives.PingSlotFreq.Type
    object PingSlotPeriod extends Subtype[Int]
    type PingSlotPeriod =
      zio.aws.iotwireless.model.primitives.PingSlotPeriod.Type
    object PrAllowed extends Subtype[Boolean]
    type PrAllowed = zio.aws.iotwireless.model.primitives.PrAllowed.Type
    object PresetFreq extends Subtype[Int]
    type PresetFreq = zio.aws.iotwireless.model.primitives.PresetFreq.Type
    object QueryString extends Subtype[String]
    type QueryString = zio.aws.iotwireless.model.primitives.QueryString.Type
    object RaAllowed extends Subtype[Boolean]
    type RaAllowed = zio.aws.iotwireless.model.primitives.RaAllowed.Type
    object RegParamsRevision extends Subtype[String]
    type RegParamsRevision =
      zio.aws.iotwireless.model.primitives.RegParamsRevision.Type
    object ReportDevStatusBattery extends Subtype[Boolean]
    type ReportDevStatusBattery =
      zio.aws.iotwireless.model.primitives.ReportDevStatusBattery.Type
    object ReportDevStatusMargin extends Subtype[Boolean]
    type ReportDevStatusMargin =
      zio.aws.iotwireless.model.primitives.ReportDevStatusMargin.Type
    object ResourceIdentifier extends Subtype[String]
    type ResourceIdentifier =
      zio.aws.iotwireless.model.primitives.ResourceIdentifier.Type
    object ResourceType extends Subtype[String]
    type ResourceType = zio.aws.iotwireless.model.primitives.ResourceType.Type
    object Result extends Subtype[String]
    type Result = zio.aws.iotwireless.model.primitives.Result.Type
    object RfRegion extends Subtype[String]
    type RfRegion = zio.aws.iotwireless.model.primitives.RfRegion.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.iotwireless.model.primitives.RoleArn.Type
    object RxDataRate2 extends Subtype[Int]
    type RxDataRate2 = zio.aws.iotwireless.model.primitives.RxDataRate2.Type
    object RxDelay1 extends Subtype[Int]
    type RxDelay1 = zio.aws.iotwireless.model.primitives.RxDelay1.Type
    object RxDrOffset1 extends Subtype[Int]
    type RxDrOffset1 = zio.aws.iotwireless.model.primitives.RxDrOffset1.Type
    object RxFreq2 extends Subtype[Int]
    type RxFreq2 = zio.aws.iotwireless.model.primitives.RxFreq2.Type
    object SNwkSIntKey extends Subtype[String]
    type SNwkSIntKey = zio.aws.iotwireless.model.primitives.SNwkSIntKey.Type
    object Seq extends Subtype[Int]
    type Seq = zio.aws.iotwireless.model.primitives.Seq.Type
    object ServiceProfileArn extends Subtype[String]
    type ServiceProfileArn =
      zio.aws.iotwireless.model.primitives.ServiceProfileArn.Type
    object ServiceProfileId extends Subtype[String]
    type ServiceProfileId =
      zio.aws.iotwireless.model.primitives.ServiceProfileId.Type
    object ServiceProfileName extends Subtype[String]
    type ServiceProfileName =
      zio.aws.iotwireless.model.primitives.ServiceProfileName.Type
    object SessionStartTimeTimestamp extends Subtype[Instant]
    type SessionStartTimeTimestamp =
      zio.aws.iotwireless.model.primitives.SessionStartTimeTimestamp.Type
    object SessionTimeout extends Subtype[Int]
    type SessionTimeout =
      zio.aws.iotwireless.model.primitives.SessionTimeout.Type
    object SidewalkId extends Subtype[String]
    type SidewalkId = zio.aws.iotwireless.model.primitives.SidewalkId.Type
    object SidewalkManufacturingSn extends Subtype[String]
    type SidewalkManufacturingSn =
      zio.aws.iotwireless.model.primitives.SidewalkManufacturingSn.Type
    object StartTime extends Subtype[Instant]
    type StartTime = zio.aws.iotwireless.model.primitives.StartTime.Type
    object Station extends Subtype[String]
    type Station = zio.aws.iotwireless.model.primitives.Station.Type
    object SubBand extends Subtype[Int]
    type SubBand = zio.aws.iotwireless.model.primitives.SubBand.Type
    object Supports32BitFCnt extends Subtype[Boolean]
    type Supports32BitFCnt =
      zio.aws.iotwireless.model.primitives.Supports32BitFCnt.Type
    object SupportsClassB extends Subtype[Boolean]
    type SupportsClassB =
      zio.aws.iotwireless.model.primitives.SupportsClassB.Type
    object SupportsClassC extends Subtype[Boolean]
    type SupportsClassC =
      zio.aws.iotwireless.model.primitives.SupportsClassC.Type
    object SupportsJoin extends Subtype[Boolean]
    type SupportsJoin = zio.aws.iotwireless.model.primitives.SupportsJoin.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.iotwireless.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.iotwireless.model.primitives.TagValue.Type
    object TargetPer extends Subtype[Int]
    type TargetPer = zio.aws.iotwireless.model.primitives.TargetPer.Type
    object ThingArn extends Subtype[String]
    type ThingArn = zio.aws.iotwireless.model.primitives.ThingArn.Type
    object ThingName extends Subtype[String]
    type ThingName = zio.aws.iotwireless.model.primitives.ThingName.Type
    object TransmitMode extends Subtype[Int]
    type TransmitMode = zio.aws.iotwireless.model.primitives.TransmitMode.Type
    object UlBucketSize extends Subtype[Int]
    type UlBucketSize = zio.aws.iotwireless.model.primitives.UlBucketSize.Type
    object UlRate extends Subtype[Int]
    type UlRate = zio.aws.iotwireless.model.primitives.UlRate.Type
    object UlRatePolicy extends Subtype[String]
    type UlRatePolicy = zio.aws.iotwireless.model.primitives.UlRatePolicy.Type
    object UpdateDataSource extends Subtype[String]
    type UpdateDataSource =
      zio.aws.iotwireless.model.primitives.UpdateDataSource.Type
    object UpdateSignature extends Subtype[String]
    type UpdateSignature =
      zio.aws.iotwireless.model.primitives.UpdateSignature.Type
    object WirelessDeviceArn extends Subtype[String]
    type WirelessDeviceArn =
      zio.aws.iotwireless.model.primitives.WirelessDeviceArn.Type
    object WirelessDeviceId extends Subtype[String]
    type WirelessDeviceId =
      zio.aws.iotwireless.model.primitives.WirelessDeviceId.Type
    object WirelessDeviceName extends Subtype[String]
    type WirelessDeviceName =
      zio.aws.iotwireless.model.primitives.WirelessDeviceName.Type
    object WirelessGatewayArn extends Subtype[String]
    type WirelessGatewayArn =
      zio.aws.iotwireless.model.primitives.WirelessGatewayArn.Type
    object WirelessGatewayId extends Subtype[String]
    type WirelessGatewayId =
      zio.aws.iotwireless.model.primitives.WirelessGatewayId.Type
    object WirelessGatewayName extends Subtype[String]
    type WirelessGatewayName =
      zio.aws.iotwireless.model.primitives.WirelessGatewayName.Type
    object WirelessGatewayTaskDefinitionArn extends Subtype[String]
    type WirelessGatewayTaskDefinitionArn =
      zio.aws.iotwireless.model.primitives.WirelessGatewayTaskDefinitionArn.Type
    object WirelessGatewayTaskDefinitionId extends Subtype[String]
    type WirelessGatewayTaskDefinitionId =
      zio.aws.iotwireless.model.primitives.WirelessGatewayTaskDefinitionId.Type
    object WirelessGatewayTaskName extends Subtype[String]
    type WirelessGatewayTaskName =
      zio.aws.iotwireless.model.primitives.WirelessGatewayTaskName.Type
  }
  type DestinationList = List[zio.aws.iotwireless.model.Destinations]
  type DeviceCertificateList = List[zio.aws.iotwireless.model.CertificateList]
  type DeviceProfileList = List[zio.aws.iotwireless.model.DeviceProfile]
  type DownlinkQueueMessagesList =
    List[zio.aws.iotwireless.model.DownlinkQueueMessage]
  type FactoryPresetFreqsList = List[PresetFreq]
  type FuotaTaskList = List[zio.aws.iotwireless.model.FuotaTask]
  type JoinEuiFilters = List[Iterable[JoinEui]]
  type JoinEuiRange = List[JoinEui]
  type LoRaWANGatewayMetadataList =
    List[zio.aws.iotwireless.model.LoRaWANGatewayMetadata]
  type MulticastGroupList = List[zio.aws.iotwireless.model.MulticastGroup]
  type MulticastGroupListByFuotaTask =
    List[zio.aws.iotwireless.model.MulticastGroupByFuotaTask]
  type NetIdFilters = List[NetId]
  type ServiceProfileList = List[zio.aws.iotwireless.model.ServiceProfile]
  type SidewalkAccountList =
    List[zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint]
  type SubBands = List[SubBand]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.iotwireless.model.Tag]
  type WirelessDeviceEventLogOptionList =
    List[zio.aws.iotwireless.model.WirelessDeviceEventLogOption]
  type WirelessDeviceList = List[WirelessDeviceId]
  type WirelessDeviceLogOptionList =
    List[zio.aws.iotwireless.model.WirelessDeviceLogOption]
  type WirelessDeviceStatisticsList =
    List[zio.aws.iotwireless.model.WirelessDeviceStatistics]
  type WirelessGatewayEventLogOptionList =
    List[zio.aws.iotwireless.model.WirelessGatewayEventLogOption]
  type WirelessGatewayList = List[WirelessGatewayId]
  type WirelessGatewayLogOptionList =
    List[zio.aws.iotwireless.model.WirelessGatewayLogOption]
  type WirelessGatewayStatisticsList =
    List[zio.aws.iotwireless.model.WirelessGatewayStatistics]
  type WirelessGatewayTaskDefinitionList =
    List[zio.aws.iotwireless.model.UpdateWirelessGatewayTaskEntry]
}
