package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait WirelessGatewayTaskStatus {
  def unwrap: software.amazon.awssdk.services.iotwireless.model.WirelessGatewayTaskStatus
}
object WirelessGatewayTaskStatus {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.WirelessGatewayTaskStatus
  ): zio.aws.iotwireless.model.WirelessGatewayTaskStatus = value match {
    case software.amazon.awssdk.services.iotwireless.model.WirelessGatewayTaskStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessGatewayTaskStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessGatewayTaskStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessGatewayTaskStatus.FIRST_RETRY =>
      val r = FIRST_RETRY
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessGatewayTaskStatus.SECOND_RETRY =>
      val r = SECOND_RETRY
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessGatewayTaskStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessGatewayTaskStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.WirelessGatewayTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessGatewayTaskStatus =
      software.amazon.awssdk.services.iotwireless.model.WirelessGatewayTaskStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING
      extends zio.aws.iotwireless.model.WirelessGatewayTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessGatewayTaskStatus =
      software.amazon.awssdk.services.iotwireless.model.WirelessGatewayTaskStatus.PENDING
  }
  case object IN_PROGRESS
      extends zio.aws.iotwireless.model.WirelessGatewayTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessGatewayTaskStatus =
      software.amazon.awssdk.services.iotwireless.model.WirelessGatewayTaskStatus.IN_PROGRESS
  }
  case object FIRST_RETRY
      extends zio.aws.iotwireless.model.WirelessGatewayTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessGatewayTaskStatus =
      software.amazon.awssdk.services.iotwireless.model.WirelessGatewayTaskStatus.FIRST_RETRY
  }
  case object SECOND_RETRY
      extends zio.aws.iotwireless.model.WirelessGatewayTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessGatewayTaskStatus =
      software.amazon.awssdk.services.iotwireless.model.WirelessGatewayTaskStatus.SECOND_RETRY
  }
  case object COMPLETED
      extends zio.aws.iotwireless.model.WirelessGatewayTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessGatewayTaskStatus =
      software.amazon.awssdk.services.iotwireless.model.WirelessGatewayTaskStatus.COMPLETED
  }
  case object FAILED
      extends zio.aws.iotwireless.model.WirelessGatewayTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessGatewayTaskStatus =
      software.amazon.awssdk.services.iotwireless.model.WirelessGatewayTaskStatus.FAILED
  }
}
