package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  WirelessGatewayId,
  WirelessDeviceId,
  NetworkAnalyzerConfigurationName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateNetworkAnalyzerConfigurationRequest(
    configurationName: NetworkAnalyzerConfigurationName,
    traceContent: Optional[zio.aws.iotwireless.model.TraceContent] =
      Optional.Absent,
    wirelessDevicesToAdd: Optional[Iterable[WirelessDeviceId]] =
      Optional.Absent,
    wirelessDevicesToRemove: Optional[Iterable[WirelessDeviceId]] =
      Optional.Absent,
    wirelessGatewaysToAdd: Optional[Iterable[WirelessGatewayId]] =
      Optional.Absent,
    wirelessGatewaysToRemove: Optional[Iterable[WirelessGatewayId]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.UpdateNetworkAnalyzerConfigurationRequest = {
    import UpdateNetworkAnalyzerConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.UpdateNetworkAnalyzerConfigurationRequest
      .builder()
      .configurationName(
        NetworkAnalyzerConfigurationName.unwrap(
          configurationName
        ): java.lang.String
      )
      .optionallyWith(traceContent.map(value => value.buildAwsValue()))(
        _.traceContent
      )
      .optionallyWith(
        wirelessDevicesToAdd.map(value =>
          value.map { item =>
            WirelessDeviceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.wirelessDevicesToAdd)
      .optionallyWith(
        wirelessDevicesToRemove.map(value =>
          value.map { item =>
            WirelessDeviceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.wirelessDevicesToRemove)
      .optionallyWith(
        wirelessGatewaysToAdd.map(value =>
          value.map { item =>
            WirelessGatewayId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.wirelessGatewaysToAdd)
      .optionallyWith(
        wirelessGatewaysToRemove.map(value =>
          value.map { item =>
            WirelessGatewayId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.wirelessGatewaysToRemove)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.UpdateNetworkAnalyzerConfigurationRequest.ReadOnly =
    zio.aws.iotwireless.model.UpdateNetworkAnalyzerConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateNetworkAnalyzerConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.UpdateNetworkAnalyzerConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.UpdateNetworkAnalyzerConfigurationRequest =
      zio.aws.iotwireless.model.UpdateNetworkAnalyzerConfigurationRequest(
        configurationName,
        traceContent.map(value => value.asEditable),
        wirelessDevicesToAdd.map(value => value),
        wirelessDevicesToRemove.map(value => value),
        wirelessGatewaysToAdd.map(value => value),
        wirelessGatewaysToRemove.map(value => value)
      )
    def configurationName: NetworkAnalyzerConfigurationName
    def traceContent: Optional[zio.aws.iotwireless.model.TraceContent.ReadOnly]
    def wirelessDevicesToAdd: Optional[List[WirelessDeviceId]]
    def wirelessDevicesToRemove: Optional[List[WirelessDeviceId]]
    def wirelessGatewaysToAdd: Optional[List[WirelessGatewayId]]
    def wirelessGatewaysToRemove: Optional[List[WirelessGatewayId]]
    def getConfigurationName
        : ZIO[Any, Nothing, NetworkAnalyzerConfigurationName] =
      ZIO.succeed(configurationName)
    def getTraceContent
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.TraceContent.ReadOnly] =
      AwsError.unwrapOptionField("traceContent", traceContent)
    def getWirelessDevicesToAdd: ZIO[Any, AwsError, List[WirelessDeviceId]] =
      AwsError.unwrapOptionField("wirelessDevicesToAdd", wirelessDevicesToAdd)
    def getWirelessDevicesToRemove: ZIO[Any, AwsError, List[WirelessDeviceId]] =
      AwsError.unwrapOptionField(
        "wirelessDevicesToRemove",
        wirelessDevicesToRemove
      )
    def getWirelessGatewaysToAdd: ZIO[Any, AwsError, List[WirelessGatewayId]] =
      AwsError.unwrapOptionField("wirelessGatewaysToAdd", wirelessGatewaysToAdd)
    def getWirelessGatewaysToRemove
        : ZIO[Any, AwsError, List[WirelessGatewayId]] = AwsError
      .unwrapOptionField("wirelessGatewaysToRemove", wirelessGatewaysToRemove)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateNetworkAnalyzerConfigurationRequest
  ) extends zio.aws.iotwireless.model.UpdateNetworkAnalyzerConfigurationRequest.ReadOnly {
    override val configurationName: NetworkAnalyzerConfigurationName =
      zio.aws.iotwireless.model.primitives
        .NetworkAnalyzerConfigurationName(impl.configurationName())
    override val traceContent
        : Optional[zio.aws.iotwireless.model.TraceContent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.traceContent())
        .map(value => zio.aws.iotwireless.model.TraceContent.wrap(value))
    override val wirelessDevicesToAdd: Optional[List[WirelessDeviceId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.wirelessDevicesToAdd())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.primitives.WirelessDeviceId(item)
          }.toList
        )
    override val wirelessDevicesToRemove: Optional[List[WirelessDeviceId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.wirelessDevicesToRemove())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.primitives.WirelessDeviceId(item)
          }.toList
        )
    override val wirelessGatewaysToAdd: Optional[List[WirelessGatewayId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.wirelessGatewaysToAdd())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.primitives.WirelessGatewayId(item)
          }.toList
        )
    override val wirelessGatewaysToRemove: Optional[List[WirelessGatewayId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.wirelessGatewaysToRemove())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.primitives.WirelessGatewayId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateNetworkAnalyzerConfigurationRequest
  ): zio.aws.iotwireless.model.UpdateNetworkAnalyzerConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
