package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.FPort
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class LoRaWANSendDataToDevice(
    fPort: Optional[FPort] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANSendDataToDevice = {
    import LoRaWANSendDataToDevice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANSendDataToDevice
      .builder()
      .optionallyWith(fPort.map(value => FPort.unwrap(value): Integer))(_.fPort)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.LoRaWANSendDataToDevice.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANSendDataToDevice.wrap(buildAwsValue())
}
object LoRaWANSendDataToDevice {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANSendDataToDevice
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANSendDataToDevice =
      zio.aws.iotwireless.model
        .LoRaWANSendDataToDevice(fPort.map(value => value))
    def fPort: Optional[FPort]
    def getFPort: ZIO[Any, AwsError, FPort] =
      AwsError.unwrapOptionField("fPort", fPort)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANSendDataToDevice
  ) extends zio.aws.iotwireless.model.LoRaWANSendDataToDevice.ReadOnly {
    override val fPort: Optional[FPort] = zio.aws.core.internal
      .optionalFromNullable(impl.fPort())
      .map(value => zio.aws.iotwireless.model.primitives.FPort(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANSendDataToDevice
  ): zio.aws.iotwireless.model.LoRaWANSendDataToDevice.ReadOnly = new Wrapper(
    impl
  )
}
