package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{
  MaxResults,
  NextToken,
  WirelessDeviceId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListQueuedMessagesRequest(
    id: WirelessDeviceId,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    wirelessDeviceType: Optional[zio.aws.iotwireless.model.WirelessDeviceType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesRequest = {
    import ListQueuedMessagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesRequest
      .builder()
      .id(WirelessDeviceId.unwrap(id): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(wirelessDeviceType.map(value => value.unwrap))(
        _.wirelessDeviceType
      )
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.ListQueuedMessagesRequest.ReadOnly =
    zio.aws.iotwireless.model.ListQueuedMessagesRequest.wrap(buildAwsValue())
}
object ListQueuedMessagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.ListQueuedMessagesRequest =
      zio.aws.iotwireless.model.ListQueuedMessagesRequest(
        id,
        nextToken.map(value => value),
        maxResults.map(value => value),
        wirelessDeviceType.map(value => value)
      )
    def id: WirelessDeviceId
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def wirelessDeviceType
        : Optional[zio.aws.iotwireless.model.WirelessDeviceType]
    def getId: ZIO[Any, Nothing, WirelessDeviceId] = ZIO.succeed(id)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getWirelessDeviceType
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.WirelessDeviceType] =
      AwsError.unwrapOptionField("wirelessDeviceType", wirelessDeviceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesRequest
  ) extends zio.aws.iotwireless.model.ListQueuedMessagesRequest.ReadOnly {
    override val id: WirelessDeviceId =
      zio.aws.iotwireless.model.primitives.WirelessDeviceId(impl.id())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotwireless.model.primitives.MaxResults(value))
    override val wirelessDeviceType
        : Optional[zio.aws.iotwireless.model.WirelessDeviceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.wirelessDeviceType())
        .map(value => zio.aws.iotwireless.model.WirelessDeviceType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesRequest
  ): zio.aws.iotwireless.model.ListQueuedMessagesRequest.ReadOnly = new Wrapper(
    impl
  )
}
