package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.WirelessGatewayId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetWirelessGatewayTaskRequest(id: WirelessGatewayId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskRequest = {
    import GetWirelessGatewayTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskRequest
      .builder()
      .id(WirelessGatewayId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetWirelessGatewayTaskRequest.ReadOnly =
    zio.aws.iotwireless.model.GetWirelessGatewayTaskRequest
      .wrap(buildAwsValue())
}
object GetWirelessGatewayTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetWirelessGatewayTaskRequest =
      zio.aws.iotwireless.model.GetWirelessGatewayTaskRequest(id)
    def id: WirelessGatewayId
    def getId: ZIO[Any, Nothing, WirelessGatewayId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskRequest
  ) extends zio.aws.iotwireless.model.GetWirelessGatewayTaskRequest.ReadOnly {
    override val id: WirelessGatewayId =
      zio.aws.iotwireless.model.primitives.WirelessGatewayId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskRequest
  ): zio.aws.iotwireless.model.GetWirelessGatewayTaskRequest.ReadOnly =
    new Wrapper(impl)
}
