package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.IotCertificateId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetWirelessGatewayCertificateResponse(
    iotCertificateId: Optional[IotCertificateId] = Optional.Absent,
    loRaWANNetworkServerCertificateId: Optional[IotCertificateId] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayCertificateResponse = {
    import GetWirelessGatewayCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayCertificateResponse
      .builder()
      .optionallyWith(
        iotCertificateId.map(value =>
          IotCertificateId.unwrap(value): java.lang.String
        )
      )(_.iotCertificateId)
      .optionallyWith(
        loRaWANNetworkServerCertificateId.map(value =>
          IotCertificateId.unwrap(value): java.lang.String
        )
      )(_.loRaWANNetworkServerCertificateId)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetWirelessGatewayCertificateResponse.ReadOnly =
    zio.aws.iotwireless.model.GetWirelessGatewayCertificateResponse
      .wrap(buildAwsValue())
}
object GetWirelessGatewayCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.GetWirelessGatewayCertificateResponse =
      zio.aws.iotwireless.model.GetWirelessGatewayCertificateResponse(
        iotCertificateId.map(value => value),
        loRaWANNetworkServerCertificateId.map(value => value)
      )
    def iotCertificateId: Optional[IotCertificateId]
    def loRaWANNetworkServerCertificateId: Optional[IotCertificateId]
    def getIotCertificateId: ZIO[Any, AwsError, IotCertificateId] =
      AwsError.unwrapOptionField("iotCertificateId", iotCertificateId)
    def getLoRaWANNetworkServerCertificateId
        : ZIO[Any, AwsError, IotCertificateId] = AwsError.unwrapOptionField(
      "loRaWANNetworkServerCertificateId",
      loRaWANNetworkServerCertificateId
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayCertificateResponse
  ) extends zio.aws.iotwireless.model.GetWirelessGatewayCertificateResponse.ReadOnly {
    override val iotCertificateId: Optional[IotCertificateId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iotCertificateId())
        .map(value =>
          zio.aws.iotwireless.model.primitives.IotCertificateId(value)
        )
    override val loRaWANNetworkServerCertificateId: Optional[IotCertificateId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loRaWANNetworkServerCertificateId())
        .map(value =>
          zio.aws.iotwireless.model.primitives.IotCertificateId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayCertificateResponse
  ): zio.aws.iotwireless.model.GetWirelessGatewayCertificateResponse.ReadOnly =
    new Wrapper(impl)
}
